/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.connectors.wfs;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.utils.Tuple;
import org.gcube.dataanalysis.geo.connectors.wfs.FeaturedPolygon;
import org.gcube.dataanalysis.geo.connectors.wfs.WFSDataExplorer;
import org.gcube.dataanalysis.geo.interfaces.GISDataConnector;

public class WFS
implements GISDataConnector {
    List<FeaturedPolygon> featuresInTime;
    HashMap<Double, Map<String, String>> polygonsFeatures;

    @Override
    public List<Double> getFeaturesInTimeInstantAndArea(String layerURL, String layerName, int time, List<Tuple<Double>> coordinates3d, double BBxL, double BBxR, double BByL, double BByR) throws Exception {
        if (time > 0) {
            throw new Exception("Error Time Dimension is not supported for WFS!");
        }
        if (layerURL == null) {
            return null;
        }
        this.featuresInTime = new ArrayList<FeaturedPolygon>();
        AnalysisLogger.getLogger().debug((Object)("taking WFS features from layer: " + layerURL));
        this.featuresInTime = WFSDataExplorer.getFeatures(layerURL, layerName, BBxL, BByL, BBxR, BByR);
        this.polygonsFeatures = new HashMap();
        int tsize = coordinates3d.size();
        AnalysisLogger.getLogger().debug((Object)("Intersecting " + tsize + " vs " + this.featuresInTime.size() + " elements"));
        int ttc = 0;
        Double[] featuresarray = new Double[tsize];
        int k = 0;
        int intersections = 0;
        GeometryFactory factory = new GeometryFactory(new PrecisionModel(), 4326);
        for (Tuple<Double> triplet : coordinates3d) {
            ArrayList elements = triplet.getElements();
            CoordinateArraySequence pcoords = new CoordinateArraySequence(new Coordinate[]{new Coordinate(((Double)elements.get(0)).doubleValue(), ((Double)elements.get(1)).doubleValue())});
            if (layerURL.contains("/wxs")) {
                pcoords = new CoordinateArraySequence(new Coordinate[]{new Coordinate(((Double)elements.get(1)).doubleValue(), ((Double)elements.get(0)).doubleValue())});
            }
            Point po = new Point((CoordinateSequence)pcoords, factory);
            boolean found = false;
            for (FeaturedPolygon poly : this.featuresInTime) {
                if (poly == null || poly.p == null || !poly.p.covers((Geometry)po)) continue;
                featuresarray[k] = poly.value;
                this.polygonsFeatures.put(poly.value, poly.features);
                found = true;
                ++intersections;
                break;
            }
            po = null;
            if (!found) {
                featuresarray[k] = Double.NaN;
            }
            if (ttc % 10000 == 0) {
                AnalysisLogger.getLogger().debug((Object)("Status: " + (double)ttc * 100.0 / (double)tsize));
            }
            ++ttc;
            ++k;
        }
        AnalysisLogger.getLogger().debug((Object)("WFS-> Found " + intersections + " intersections!"));
        List<Double> features = Arrays.asList(featuresarray);
        return features;
    }

    @Override
    public double getMinZ(String layerURL, String layerName) {
        return 0.0;
    }

    @Override
    public double getMaxZ(String layerURL, String layerName) {
        return 0.0;
    }

    public HashMap<Double, Map<String, String>> getPolygonsFeatures() {
        return this.polygonsFeatures;
    }
}

