/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.util;

import java.util.ArrayList;
import java.util.List;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;

public class InfraRetrieval {
    public static List<String> retrieveAddresses(String Category2, String scope, String exclude) {
        if (scope == null || scope.length() == 0) {
            return new ArrayList<String>();
        }
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq '" + Category2 + "'").addCondition("$resource/Profile[Name[not(contains(., '" + exclude + "'))]]").setResult("$resource/Profile/AccessPoint/Interface/Endpoint/text()");
        DiscoveryClient client = ICFactory.client();
        List addresses = client.submit((Query)query);
        return addresses;
    }

    public static List<String> retrieveServiceAddress(String Category2, String Name, String scope, String exclude) {
        if (scope == null || scope.length() == 0) {
            return new ArrayList<String>();
        }
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq '" + Category2 + "'").addCondition("$resource/Profile/Name/text() eq '" + Name + "'").addCondition("$resource/Profile[Name[not(contains(., '" + exclude + "'))]]").setResult("$resource/Profile/AccessPoint/Interface/Endpoint/text()");
        DiscoveryClient client = ICFactory.client();
        List addresses = client.submit((Query)query);
        return addresses;
    }

    public static List<String> retrieveService(String service, String scope) {
        if (scope == null || scope.length() == 0) {
            return new ArrayList<String>();
        }
        XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
        query.addCondition("$resource/Profile/ServiceName/text() eq '" + service + "'").setResult("$resource/Profile/AccessPoint/RunningInstanceInterfaces/Endpoint/text()");
        DiscoveryClient client = ICFactory.client();
        List addresses = client.submit((Query)query);
        return addresses;
    }

    public static String findEmailingSystemAddress(String scope) throws Exception {
        String serviceName = "SocialNetworking";
        String serviceClass = "Portal";
        List<String> endpoints = InfraRetrieval.retrieveServiceAddress(serviceClass, serviceName, scope, "test");
        String resourceEntyName = endpoints.get(0);
        if (endpoints == null || endpoints.isEmpty()) {
            throw new Exception("Cannot retrieve the GCoreEndpoint serviceName: " + serviceName + ", serviceClass: " + serviceClass + ", in scope: " + scope);
        }
        if (resourceEntyName == null) {
            throw new Exception("Endpoint:" + serviceName + ", is null for serviceName: " + serviceName + ", serviceClass: " + serviceClass + ", in scope: " + scope);
        }
        return resourceEntyName;
    }
}

