/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.job.management;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.apache.log4j.Logger;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanager.storageclient.model.protocol.smp.Handler;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalInfraAlgorithm;

public class GenericWorker
extends StandardLocalInfraAlgorithm {
    private static String genericWorkerDir = "/genericworker/";
    public static String AlgorithmClassParameter = "AlgorithmClass";
    public static String RightSetStartIndexParameter = "RightSetStartIndex";
    public static String NumberOfRightElementsToProcessParameter = "NumberOfRightElementsToProcess";
    public static String LeftSetStartIndexParameter = "LeftSetStartIndex";
    public static String NumberOfLeftElementsToProcessParameter = "NumberOfLeftElementsToProcess";
    public static String IsDuplicateParameter = "IsDuplicate";
    public static String SessionParameter = "Session";
    public static String ConfigurationFileParameter = "ConfigurationFile";
    public static String DeleteTemporaryFilesParameter = "DeleteTemporaryFiles";
    public static String OutputParameter = "Process_Outcome";
    public static String TASK_SUCCESS = "TASK_SUCCESS";
    public static String TASK_FAILURE = "TASK_FAILURE";
    public static String TASK_UNDEFINED = "TASK_UNDEFINED";

    private static void inputStreamToFile(InputStream is, String path) throws FileNotFoundException, IOException {
        FileOutputStream out = new FileOutputStream(new File(path));
        byte[] buf = new byte[1024];
        int len = 0;
        while ((len = is.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        out.close();
    }

    public void executeAlgorithm(String algorithmClass, int rightStartIndex, int numberOfRightElementsToProcess, int leftStartIndex, int numberOfLeftElementsToProcess, boolean isduplicate, String session, File nodeConfigurationFileObject, boolean deleteFiles) throws Exception {
        PrintStream origOut = System.out;
        PrintStream origErr = System.err;
        this.status = 0.0f;
        Logger logger = AnalysisLogger.getLogger();
        StringBuffer sb = new StringBuffer();
        File tempDir = null;
        try {
            Handler.activateProtocol();
            logger.debug((Object)("GenericWorker-> Creating algorithm " + algorithmClass));
            File[] node = (File[])Class.forName(algorithmClass).newInstance();
            logger.debug((Object)("GenericWorker-> executing algorithm " + algorithmClass + " with parameters:"));
            logger.debug((Object)("GenericWorker-> rightStartIndex:" + rightStartIndex));
            logger.debug((Object)("GenericWorker-> numberOfRightElementsToProcess:" + numberOfRightElementsToProcess));
            logger.debug((Object)("GenericWorker-> leftStartIndex:" + leftStartIndex));
            logger.debug((Object)("GenericWorker-> numberOfLeftElementsToProcess:" + numberOfLeftElementsToProcess));
            logger.debug((Object)("GenericWorker-> isduplicate:" + isduplicate));
            logger.debug((Object)("GenericWorker-> execution directory:" + this.config.getConfigPath()));
            logger.debug((Object)("GenericWorker-> nodeConfigurationFileObject.getName():" + nodeConfigurationFileObject.getName()));
            logger.debug((Object)("GenericWorker-> nodeConfigurationFileObject.getPath():" + nodeConfigurationFileObject.getAbsolutePath()));
            logger.debug((Object)("GenericWorker-> session :" + session));
            logger.debug((Object)("GenericWorker-> delete files :" + deleteFiles));
            File sandboxfile = new File(this.config.getConfigPath(), nodeConfigurationFileObject.getName());
            Files.copy(nodeConfigurationFileObject.toPath(), sandboxfile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            logger.debug((Object)("GenericWorker-> copied configuration file as " + sandboxfile.getAbsolutePath()));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            System.setOut(ps);
            System.setErr(ps);
            int result = node.executeNode(leftStartIndex, numberOfLeftElementsToProcess, rightStartIndex, numberOfRightElementsToProcess, isduplicate, this.config.getConfigPath(), nodeConfigurationFileObject.getName(), "log.txt");
            System.setOut(origOut);
            System.setErr(origErr);
            String log = new String(baos.toByteArray(), StandardCharsets.UTF_8);
            boolean del = sandboxfile.delete();
            logger.debug((Object)("GenericWorker-> deleted sandbox file: " + del));
            logger.debug((Object)"GenericWorker-> all done");
            if (result != 0) {
                this.outputParameters.put(OutputParameter, TASK_FAILURE);
                String cutLog = URLEncoder.encode(log, "UTF-8");
                cutLog = log;
                this.outputParameters.put("Log", cutLog);
                logger.debug((Object)"GenericWorker-> Failure!");
            } else {
                this.outputParameters.put(OutputParameter, TASK_SUCCESS);
                logger.debug((Object)"GenericWorker-> Success!");
            }
        }
        catch (Throwable e) {
            this.outputParameters.put(OutputParameter, TASK_FAILURE);
            this.outputParameters.put("Log", e.getLocalizedMessage());
            e.printStackTrace();
            logger.debug((Object)("GenericWorker-> ERROR: " + e.getLocalizedMessage()));
            this.status = 100.0f;
            throw new Exception(e.getLocalizedMessage());
        }
        finally {
            System.setOut(origOut);
            System.setErr(origErr);
            try {
                if (deleteFiles && tempDir != null) {
                    logger.debug((Object)"GenericWorker-> ... deleting local files");
                    for (File singlefile : tempDir.listFiles()) {
                        boolean del = singlefile.delete();
                        if (!del) {
                            logger.debug((Object)("GenericWorker-> ERROR deleting " + singlefile.getName() + " " + del));
                            continue;
                        }
                        logger.debug((Object)("GenericWorker-> deleted LOCAL FILE " + singlefile.getName() + " " + del));
                    }
                    logger.debug((Object)"GenericWorker-> deleting temporary directory");
                    tempDir.delete();
                }
                if (nodeConfigurationFileObject != null && nodeConfigurationFileObject.exists()) {
                    nodeConfigurationFileObject.delete();
                }
            }
            catch (Exception e3) {
                e3.printStackTrace();
                logger.debug((Object)"GenericWorker-> Error deleting files");
            }
            this.status = 100.0f;
        }
    }

    public void init() throws Exception {
    }

    public String getDescription() {
        return "An algorithm that executes another other algorithm";
    }

    protected void process() throws Exception {
        AnalysisLogger.getLogger().debug((Object)("Parameters: " + this.config.getGeneralProperties()));
        String algorithmClass = this.config.getParam(AlgorithmClassParameter);
        int rightStartIndex = Integer.parseInt(this.config.getParam(RightSetStartIndexParameter));
        int numberOfRightElementsToProcess = Integer.parseInt(this.config.getParam(NumberOfRightElementsToProcessParameter));
        int leftStartIndex = Integer.parseInt(this.config.getParam(LeftSetStartIndexParameter));
        int numberOfLeftElementsToProcess = Integer.parseInt(this.config.getParam(NumberOfLeftElementsToProcessParameter));
        boolean isduplicate = Boolean.parseBoolean(this.config.getParam(IsDuplicateParameter));
        String session = this.config.getParam(SessionParameter);
        File nodeConfigurationFileObject = new File(this.config.getParam(ConfigurationFileParameter));
        boolean deleteFiles = Boolean.parseBoolean(this.config.getParam(DeleteTemporaryFilesParameter));
        AnalysisLogger.getLogger().debug((Object)"Executing the algorithm");
        this.executeAlgorithm(algorithmClass, rightStartIndex, numberOfRightElementsToProcess, leftStartIndex, numberOfLeftElementsToProcess, isduplicate, session, nodeConfigurationFileObject, deleteFiles);
        AnalysisLogger.getLogger().debug((Object)"Algorithm executed!");
    }

    protected void setInputParameters() {
        this.addStringInput(AlgorithmClassParameter, "The full class path of the algorithm", "org.gcube.dataanalysis.executor.nodes.transducers.bionym.BionymFlexibleWorkflowTransducer");
        this.addIntegerInput(RightSetStartIndexParameter, "The start index of the right set in a cartesian product of the input", "1");
        this.addIntegerInput(NumberOfRightElementsToProcessParameter, "The number of elements to process in the right set", "1");
        this.addIntegerInput(LeftSetStartIndexParameter, "The start index of the left set in a cartesian product of the input", "1");
        this.addIntegerInput(NumberOfLeftElementsToProcessParameter, "The number of elements to process in the left set", "1");
        this.addBooleanInput(IsDuplicateParameter, "Indicate if this sub computation is a duplicate of another sub-computation", "false");
        this.addStringInput(SessionParameter, "The session this sub-computation belongs to", "123456");
        this.addFileInput(ConfigurationFileParameter, "A configuration file for the algorithm in an XML serialisation format for the AlgorithmConfiguration Object", "config.dat");
        this.addBooleanInput(DeleteTemporaryFilesParameter, "Delete local temporary files after the computation", "true");
    }

    public void shutdown() {
    }
}

