/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.interfaces;

import java.util.HashMap;
import java.util.Map;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.interfaces.Evaluator;
import org.gcube.dataanalysis.ecoengine.utils.ResourceFactory;
import org.hibernate.SessionFactory;

public abstract class DataAnalysis
implements Evaluator {
    protected ResourceFactory resourceManager;
    protected int processedRecords;
    protected float status;
    protected AlgorithmConfiguration config;
    protected SessionFactory connection;
    HashMap<String, String> out;

    public abstract HashMap<String, String> analyze() throws Exception;

    @Override
    public void compute() throws Exception {
        this.status = 0.0f;
        this.out = new HashMap();
        try {
            this.out = this.analyze();
            this.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            this.status = 100.0f;
        }
    }

    @Override
    public StatisticalType getOutput() {
        PrimitiveType p = new PrimitiveType(Map.class.getName(), this.out, PrimitiveTypes.MAP, "AnalysisResult", "Analysis Values");
        return p;
    }

    @Override
    public String getResourceLoad() {
        if (this.resourceManager == null) {
            this.resourceManager = new ResourceFactory();
        }
        return this.resourceManager.getResourceLoad(this.processedRecords);
    }

    @Override
    public String getResources() {
        return ResourceFactory.getResources(100.0f);
    }

    @Override
    public INFRASTRUCTURE getInfrastructure() {
        return INFRASTRUCTURE.LOCAL;
    }

    @Override
    public float getStatus() {
        return this.status;
    }

    public static void visualizeResults(HashMap<String, String> results) {
        for (String key : results.keySet()) {
            System.out.println(key + ":" + results.get(key));
        }
    }

    @Override
    public void init() throws Exception {
        AnalysisLogger.setLogger(this.config.getConfigPath() + AlgorithmConfiguration.defaultLoggerFile);
        this.connection = AlgorithmConfiguration.getConnectionFromConfig(this.config);
        this.config.initRapidMiner();
    }

    @Override
    public void setConfiguration(AlgorithmConfiguration config) {
        this.config = config;
    }

    @Override
    public void shutdown() {
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

