/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.models.cores.neuralnetworks.neurosolutions;

import org.gcube.dataanalysis.ecoengine.models.cores.neuralnetworks.neurosolutions.LineReader;
import org.gcube.dataanalysis.ecoengine.models.cores.neuralnetworks.neurosolutions.Pattern;
import org.gcube.dataanalysis.ecoengine.models.cores.neuralnetworks.neurosolutions.Randomizer;

class PatternSet {
    Pattern[] patterns;
    Pattern[] trainingpatterns;
    Pattern[] crossvalpatterns;
    Pattern[] testpatterns;
    double[] crossvaldeviations;
    double[] testdeviations;
    private Randomizer randomizer;

    public PatternSet(String sourceFile, int noofinputs, int nooftargets, double ratiotraining, double ratiocrossval, double ratiotest, Randomizer randomizer) {
        int j;
        int i;
        LineReader linereader = new LineReader(sourceFile);
        int counter = 0;
        while (linereader.NextLineSplitted()) {
            try {
                for (int i2 = 0; i2 < noofinputs + nooftargets; ++i2) {
                    double temp_double = Double.parseDouble(linereader.column[i2]);
                }
                ++counter;
            }
            catch (NumberFormatException e) {}
        }
        linereader = null;
        this.patterns = new Pattern[counter];
        double[] temp_in = new double[noofinputs];
        double[] temp_tar = new double[nooftargets];
        linereader = new LineReader(sourceFile);
        counter = 0;
        while (linereader.NextLineSplitted()) {
            try {
                int i3;
                for (i3 = 0; i3 < noofinputs; ++i3) {
                    temp_in[i3] = Double.parseDouble(linereader.column[i3]);
                }
                for (i3 = noofinputs; i3 < noofinputs + nooftargets; ++i3) {
                    temp_tar[i3 - noofinputs] = Double.parseDouble(linereader.column[i3]);
                }
                this.patterns[counter++] = new Pattern(temp_in, temp_tar);
            }
            catch (NumberFormatException e) {}
        }
        linereader = null;
        this.trainingpatterns = new Pattern[(int)Math.round((double)this.patterns.length * ratiotraining)];
        this.crossvalpatterns = new Pattern[(int)Math.round((double)this.patterns.length * ratiocrossval)];
        this.testpatterns = new Pattern[this.patterns.length - this.trainingpatterns.length - this.crossvalpatterns.length];
        int patternsnotselected = this.patterns.length;
        block9: for (i = 0; i < this.trainingpatterns.length; ++i) {
            int patterntoselect = randomizer.random.nextInt(patternsnotselected);
            counter = 0;
            for (j = 0; j < this.patterns.length; ++j) {
                if (this.patterns[j].selected) continue;
                if (counter == patterntoselect) {
                    this.trainingpatterns[i] = this.patterns[j];
                    this.patterns[j].selected = true;
                    --patternsnotselected;
                    continue block9;
                }
                ++counter;
            }
        }
        block11: for (i = 0; i < this.crossvalpatterns.length; ++i) {
            int patterntoselect = randomizer.random.nextInt(patternsnotselected);
            counter = 0;
            for (j = 0; j < this.patterns.length; ++j) {
                if (this.patterns[j].selected) continue;
                if (counter == patterntoselect) {
                    this.crossvalpatterns[i] = this.patterns[j];
                    this.patterns[j].selected = true;
                    --patternsnotselected;
                    continue block11;
                }
                ++counter;
            }
        }
        block13: for (i = 0; i < this.testpatterns.length; ++i) {
            int patterntoselect = randomizer.random.nextInt(patternsnotselected);
            counter = 0;
            for (j = 0; j < this.patterns.length; ++j) {
                if (this.patterns[j].selected) continue;
                if (counter == patterntoselect) {
                    this.testpatterns[i] = this.patterns[j];
                    this.patterns[j].selected = true;
                    --patternsnotselected;
                    continue block13;
                }
                ++counter;
            }
        }
        for (i = 0; i < this.patterns.length; ++i) {
            this.patterns[i].selected = false;
        }
        double[] averages = new double[nooftargets];
        this.crossvaldeviations = new double[nooftargets];
        this.testdeviations = new double[nooftargets];
        for (int i4 = 0; i4 < nooftargets; ++i4) {
            int j2;
            averages[i4] = 0.0;
            for (j2 = 0; j2 < this.crossvalpatterns.length; ++j2) {
                int n = i4;
                averages[n] = averages[n] + this.crossvalpatterns[j2].target[i4];
            }
            int n = i4;
            averages[n] = averages[n] / (double)this.crossvalpatterns.length;
            this.crossvaldeviations[i4] = 0.0;
            for (j2 = 0; j2 < this.crossvalpatterns.length; ++j2) {
                int n2 = i4;
                this.crossvaldeviations[n2] = this.crossvaldeviations[n2] + Math.abs(this.crossvalpatterns[j2].target[i4] - averages[i4]);
            }
            this.crossvaldeviations[i4] = this.crossvaldeviations[i4] * 2.0 / (double)this.crossvalpatterns.length;
            averages[i4] = 0.0;
            for (j2 = 0; j2 < this.testpatterns.length; ++j2) {
                int n3 = i4;
                averages[n3] = averages[n3] + this.testpatterns[j2].target[i4];
            }
            int n4 = i4;
            averages[n4] = averages[n4] / (double)this.testpatterns.length;
            this.testdeviations[i4] = 0.0;
            for (j2 = 0; j2 < this.testpatterns.length; ++j2) {
                int n5 = i4;
                this.testdeviations[n5] = this.testdeviations[n5] + Math.abs(this.testpatterns[j2].target[i4] - averages[i4]);
            }
            this.testdeviations[i4] = this.testdeviations[i4] * 2.0 / (double)this.testpatterns.length;
        }
    }
}

