/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.transducers;

import org.gcube.contentmanagement.lexicalmatcher.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.test.regression.Regressor;
import org.gcube.dataanalysis.ecoengine.transducers.OccurrencePointsMerger;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;

public class OccurrencePointsIntersector
extends OccurrencePointsMerger {
    @Override
    public String getDescription() {
        return "An algorithm for intesecting two sets of occurrence points of species coming from the Species Discovery Facility of D4Science";
    }

    @Override
    protected void prepareFinalTable() throws Exception {
        DatabaseFactory.executeSQLUpdate(DatabaseUtils.createBlankTableFromAnotherStatement(this.leftTableName, this.finalTableName), this.dbconnection);
    }

    @Override
    protected void manageHighProbability(float probability, OccurrencePointsMerger.OccurrenceRecord leftOcc, OccurrencePointsMerger.OccurrenceRecord rightOcc) {
        if (leftOcc.modifdate != null && rightOcc.modifdate != null && leftOcc.modifdate.before(rightOcc.modifdate) || leftOcc.modifdate == null && rightOcc.modifdate != null) {
            this.objectstoinsert.add(rightOcc);
        } else if (leftOcc.modifdate != null && rightOcc.modifdate != null && leftOcc.modifdate.after(rightOcc.modifdate) || leftOcc.modifdate != null && rightOcc.modifdate == null) {
            this.objectstoinsert.add(leftOcc);
        } else {
            this.objectstoinsert.add(leftOcc);
        }
    }

    @Override
    protected void manageLowProbability(float probability, OccurrencePointsMerger.OccurrenceRecord leftOcc, OccurrencePointsMerger.OccurrenceRecord rightOcc) {
    }

    public static void main(String[] args) throws Exception {
        AlgorithmConfiguration config = Regressor.getConfig();
        config.setNumberOfResources(1);
        config.setParam(longitudeColumn, "decimallongitude");
        config.setParam(latitudeColumn, "decimallatitude");
        config.setParam(recordedByColumn, "recordedby");
        config.setParam(scientificNameColumn, "scientificname");
        config.setParam(eventDateColumn, "eventdate");
        config.setParam(lastModificationColumn, "modified");
        config.setParam(rightTableNameF, "whitesharkoccurrences2");
        config.setParam(leftTableNameF, "whitesharkoccurrences1");
        config.setParam(finalTableNameF, "whitesharkoccurrencesintersected");
        config.setParam(spatialTolerance, "0.5");
        config.setParam(confidence, "0.8");
        OccurrencePointsIntersector occm = new OccurrencePointsIntersector();
        occm.setConfiguration(config);
        occm.init();
        occm.compute();
    }
}

