/*
 * Decompiled with CFR 0.152.
 */
package ucar.httpservices;

import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import ucar.httpservices.HTTPMethod;
import ucar.httpservices.HTTPSession;

public class HTTPMethodStream
extends FilterInputStream
implements Closeable {
    public static Logger log = HTTPSession.log;
    HTTPMethod method = null;
    InputStream stream = null;
    boolean closed = false;

    HTTPMethodStream(InputStream stream, HTTPMethod method) {
        super(stream);
        this.method = method;
        this.stream = stream;
    }

    boolean getClosed() {
        return this.closed;
    }

    InputStream getStream() {
        return this.stream;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.consume();
        }
        finally {
            super.close();
        }
        if (this.method != null) {
            this.method.close();
        }
    }

    void consume() {
        try {
            long available;
            long consumed = 0L;
            while ((available = (long)this.available()) > 0L) {
                consumed += this.skip(available);
            }
            if (consumed > 0L) {
                log.debug("HTTPMethodStream: unconsumed data");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isClosed() {
        return this.closed;
    }
}

