/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.point;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.DataIterator;
import ucar.nc2.dt.DatatypeIterator;
import ucar.nc2.dt.StationImpl;
import ucar.nc2.dt.StationObsDatatype;
import ucar.nc2.dt.TypedDataset;
import ucar.nc2.dt.TypedDatasetFactoryIF;
import ucar.nc2.dt.point.RecordDatasetHelper;
import ucar.nc2.dt.point.StationObsDatasetImpl;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.Station;

public class UnidataStationObsDataset2
extends StationObsDatasetImpl
implements TypedDatasetFactoryIF {
    private Structure recordVar;
    private RecordDatasetHelper recordHelper;
    private boolean debugRead = false;

    public static boolean isValidFile(NetcdfFile ds) {
        return ds.findAttValueIgnoreCase(null, "Conventions", "").equalsIgnoreCase("Unidata Station Format v1.0");
    }

    @Override
    public boolean isMine(NetcdfDataset ds) {
        return UnidataStationObsDataset2.isValidFile(ds);
    }

    @Override
    public TypedDataset open(NetcdfDataset ncd, CancelTask task, StringBuilder errlog) throws IOException {
        return new UnidataStationObsDataset2(ncd);
    }

    public UnidataStationObsDataset2() {
    }

    public UnidataStationObsDataset2(NetcdfDataset ds) throws IOException {
        super(ds);
        this.title = "Station Data from NWS";
        this.desc = "Station Data from NWS distributed through the Unidata IDD realtime datastream. Decoded into netCDF files by metar2nc (new). Usually 1 hour of data";
        this.recordHelper = new RecordDatasetHelper(ds, "time_observation", "time_nominal", this.dataVariables, this.parseInfo);
        this.recordHelper.setStationInfo("station_index", "location");
        this.removeDataVariable("time_observation");
        this.removeDataVariable("time_nominal");
        this.removeDataVariable("previousReport");
        this.removeDataVariable("station_index");
        this.recordVar = this.recordHelper.recordVar;
        this.timeUnit = this.recordHelper.timeUnit;
        ArrayChar stationIdArray = (ArrayChar)ds.findVariable("id").read();
        ArrayChar stationDescArray = (ArrayChar)ds.findVariable("location").read();
        Array latArray = ds.findVariable("latitude").read();
        Array lonArray = ds.findVariable("longitude").read();
        Array elevArray = ds.findVariable("elevation").read();
        Array lastRecordArray = ds.findVariable("lastReport").read();
        Array numReportsArray = ds.findVariable("numberReports").read();
        Index ima = lastRecordArray.getIndex();
        int n = ds.findVariable("number_stations").readScalarInt();
        this.recordHelper.stnHash = new HashMap<Object, Station>(2 * n);
        for (int i = 0; i < n; ++i) {
            ima.set(i);
            String stationName = stationIdArray.getString(i).trim();
            String stationDesc = stationDescArray.getString(i).trim();
            UnidataStationImpl bean = new UnidataStationImpl(stationName, stationDesc, latArray.getFloat(ima), lonArray.getFloat(ima), elevArray.getFloat(ima), lastRecordArray.getInt(ima), numReportsArray.getInt(ima));
            this.stations.add(bean);
            this.recordHelper.stnHash.put(new Integer(i), bean);
        }
        this.setBoundingBox();
        Variable minTimeVar = ds.findVariable("minimum_time_observation");
        int minTimeValue = minTimeVar.readScalarInt();
        this.startDate = this.timeUnit.makeDate(minTimeValue);
        Variable maxTimeVar = ds.findVariable("maximum_time_observation");
        int maxTimeValue = maxTimeVar.readScalarInt();
        this.endDate = this.timeUnit.makeDate(maxTimeValue);
    }

    @Override
    protected void setTimeUnits() {
    }

    @Override
    protected void setStartDate() {
    }

    @Override
    protected void setEndDate() {
    }

    @Override
    protected void setBoundingBox() {
        this.boundingBox = this.stationHelper.getBoundingBox();
    }

    @Override
    public List getData(CancelTask cancel) throws IOException {
        ArrayList<StationObsDatatype> allData = new ArrayList<StationObsDatatype>();
        for (int i = 0; i < this.getDataCount(); ++i) {
            allData.add(this.makeObs(i));
            if (cancel == null || !cancel.isCancel()) continue;
            return null;
        }
        return allData;
    }

    @Override
    public int getDataCount() {
        Dimension unlimitedDim = this.netcdfDataset.getUnlimitedDimension();
        return unlimitedDim.getLength();
    }

    @Override
    public List getData(Station s, CancelTask cancel) throws IOException {
        return ((UnidataStationImpl)s).getObservations();
    }

    protected StationObsDatatype makeObs(int recno) throws IOException {
        try {
            StructureData sdata = this.recordVar.readStructure(recno);
            int stationIndex = sdata.getScalarInt("station_index");
            Station station = (Station)this.stations.get(stationIndex);
            if (station == null) {
                this.parseInfo.append("cant find station at index = " + stationIndex + "\n");
            }
            float obsTime = sdata.convertScalarFloat("time_observation");
            float nomTime = sdata.convertScalarFloat("time_nominal");
            RecordDatasetHelper recordDatasetHelper = this.recordHelper;
            recordDatasetHelper.getClass();
            return recordDatasetHelper.new RecordDatasetHelper.RecordStationObs(station, (double)obsTime, (double)nomTime, recno);
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public DataIterator getDataIterator(int bufferSize) throws IOException {
        return new StationDatatypeIterator(this.recordHelper.recordVar, bufferSize);
    }

    private class StationDatatypeIterator
    extends DatatypeIterator {
        @Override
        protected Object makeDatatypeWithData(int recnum, StructureData sdata) {
            RecordDatasetHelper recordDatasetHelper = UnidataStationObsDataset2.this.recordHelper;
            recordDatasetHelper.getClass();
            return recordDatasetHelper.new RecordDatasetHelper.RecordStationObs(recnum, sdata);
        }

        StationDatatypeIterator(Structure struct, int bufferSize) {
            super(struct, bufferSize);
        }
    }

    private class UnidataStationImpl
    extends StationImpl {
        private int lastRecord;

        private UnidataStationImpl(String name, String desc, double lat, double lon, double elev, int lastRecord, int count) {
            super(name, desc, lat, lon, elev, count);
            this.lastRecord = lastRecord;
        }

        protected ArrayList readObservations() throws IOException {
            ArrayList<RecordDatasetHelper.RecordStationObs> obs = new ArrayList<RecordDatasetHelper.RecordStationObs>();
            int recno = this.lastRecord;
            while (recno >= 0) {
                try {
                    if (UnidataStationObsDataset2.this.debugRead) {
                        System.out.println(this.name + " try to read at record " + recno);
                    }
                    StructureData sdata = UnidataStationObsDataset2.this.recordVar.readStructure(recno);
                    int prevRecord = sdata.getScalarInt("previousReport");
                    float obsTime = sdata.convertScalarFloat("time_observation");
                    float nomTime = sdata.convertScalarFloat("time_nominal");
                    RecordDatasetHelper recordDatasetHelper = UnidataStationObsDataset2.this.recordHelper;
                    recordDatasetHelper.getClass();
                    obs.add(0, recordDatasetHelper.new RecordDatasetHelper.RecordStationObs((Station)this, (double)obsTime, (double)nomTime, recno));
                    recno = prevRecord;
                }
                catch (InvalidRangeException e) {
                    e.printStackTrace();
                    throw new IOException(e.getMessage());
                }
            }
            return obs;
        }
    }
}

