/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.oscar.util;

import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gcube.dataanalysis.oscar.util.FileBasedProxyConfiguration;
import org.gcube.dataanalysis.oscar.util.NetworkConfiguration;

public class PropertiesBasedProxySelector
extends ProxySelector {
    List<Proxy> proxies = null;
    List<String> nonProxyHosts = null;

    public PropertiesBasedProxySelector(String proxySettingsPath) {
        this(new FileBasedProxyConfiguration(proxySettingsPath));
    }

    public PropertiesBasedProxySelector(NetworkConfiguration config) {
        if (config == null || config.getProxyHost() == null) {
            this.proxies = null;
            return;
        }
        String host = config.getProxyHost();
        int port = 80;
        if (config.getProxyPort() != null) {
            port = Integer.valueOf(config.getProxyPort());
        }
        if (config.getNonProxyHosts() != null) {
            this.nonProxyHosts = Arrays.asList(config.getNonProxyHosts().split("\\|"));
        }
        this.proxies = new ArrayList<Proxy>();
        this.proxies.add(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port)));
        if (config.getProxyUser() != null) {
            final String username = config.getProxyUser();
            final String password = config.getProxyPassword();
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password.toCharArray());
                }
            });
        }
    }

    @Override
    public List<Proxy> select(URI uri) {
        if (this.nonProxyHosts == null) {
            return Arrays.asList(Proxy.NO_PROXY);
        }
        for (String entry : this.nonProxyHosts) {
            if ((entry = entry.trim()).startsWith("*") && uri.getHost().endsWith(entry.substring(1))) {
                return Arrays.asList(Proxy.NO_PROXY);
            }
            if (!uri.getHost().equals(entry)) continue;
            return Arrays.asList(Proxy.NO_PROXY);
        }
        return this.proxies;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress socketAddress, IOException e) {
    }
}

