/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.oscar.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FTPDownloader {
    private static final Logger logger = LoggerFactory.getLogger(FTPDownloader.class);
    private FTPClient ftp = new FTPClient();

    public FTPDownloader(String url) throws Exception {
        this(FTPDownloader.getFtpHost(url), "anonymous", null);
    }

    public FTPDownloader(String host, String user, String pwd) throws Exception {
        this.ftp.connect(host);
        int reply = this.ftp.getReplyCode();
        if (!FTPReply.isPositiveCompletion(reply)) {
            this.ftp.disconnect();
            throw new Exception("Exception in connecting to FTP Server");
        }
        this.ftp.login(user, pwd);
        this.ftp.setFileType(2);
        this.ftp.enterLocalPassiveMode();
        this.ftp.setControlKeepAliveTimeout(300L);
    }

    public void downloadFile(String remoteFilePath, String localFilePath) {
        if (remoteFilePath.startsWith("ftp://")) {
            remoteFilePath = FTPDownloader.getFtpPath(remoteFilePath);
        }
        try (FileOutputStream fos = new FileOutputStream(localFilePath);){
            this.ftp.retrieveFile(remoteFilePath, fos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<String> listFiles(String directory) {
        Vector<String> out = new Vector<String>();
        try {
            this.ftp.changeWorkingDirectory(directory);
            for (FTPFile f : this.ftp.listFiles()) {
                out.add(f.getName());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out;
    }

    public boolean checkFileExists(String remoteFilePath) throws IOException {
        String directory = FTPDownloader.getFtpDirectory(remoteFilePath);
        String file = FTPDownloader.getFtpFile(remoteFilePath);
        return this.listFiles(directory).contains(file);
    }

    public void disconnect() {
        if (this.ftp.isConnected()) {
            try {
                this.ftp.logout();
                this.ftp.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static String getFtpHost(String ftpSource) {
        if (ftpSource.startsWith("ftp:")) {
            String tmp = ftpSource.substring(6);
            return tmp.split("/")[0];
        }
        return null;
    }

    private static String getFtpPath(String ftpSource) {
        if (ftpSource.startsWith("ftp:")) {
            String tmp = ftpSource.substring(6);
            return tmp.split("/", 2)[1];
        }
        return null;
    }

    private static String getFtpDirectory(String ftpSource) {
        String file = FTPDownloader.getFtpPath(ftpSource);
        if (file != null) {
            String directory = file.substring(0, file.lastIndexOf("/"));
            return directory;
        }
        return null;
    }

    private static String getFtpFile(String ftpSource) {
        String path = FTPDownloader.getFtpPath(ftpSource);
        if (path != null) {
            String file = path.substring(path.lastIndexOf("/") + 1);
            return file;
        }
        return null;
    }

    public static boolean checkFtpFileExists(String ftpURL) {
        FTPDownloader downloader = null;
        try {
            downloader = new FTPDownloader(ftpURL);
            boolean bl = downloader.checkFileExists(ftpURL);
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (downloader != null) {
                downloader.disconnect();
            }
        }
        return false;
    }
}

