/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jdom2.Element;
import thredds.catalog.InvAccess;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.ServiceType;
import thredds.catalog.XMLEntityResolver;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFilter;
import ucar.nc2.units.DateType;

public class CrawlableCatalog
implements CrawlableDataset {
    private String catalogURL;
    private Object configObj;
    private ServiceType serviceType;
    private InvCatalogImpl catalog;
    private InvDatasetImpl dataset;
    private CrawlableCatalog parent;
    private boolean isCollection;

    public CrawlableCatalog(String catalogURL, Object configObj) {
        Element configElement;
        Element serviceElement;
        this.catalogURL = catalogURL;
        this.configObj = configObj;
        if (configObj instanceof Element && null != (serviceElement = (configElement = (Element)configObj).getChild("serviceType", XMLEntityResolver.ncmlNS))) {
            String service = serviceElement.getTextTrim();
            this.serviceType = ServiceType.getType(service);
        }
        InvCatalogFactory catFactory = InvCatalogFactory.getDefaultFactory(true);
        this.catalog = catFactory.readXML(catalogURL);
        this.dataset = this.catalog.getDataset();
        this.isCollection = true;
    }

    CrawlableCatalog(CrawlableCatalog parent, InvDatasetImpl dataset) {
        this.parent = parent;
        this.dataset = dataset;
        this.serviceType = parent.serviceType;
        this.isCollection = dataset instanceof InvCatalogRef ? true : dataset.hasNestedDatasets();
    }

    @Override
    public Object getConfigObject() {
        return this.configObj;
    }

    @Override
    public String getPath() {
        InvAccess access;
        if (this.serviceType != null && (access = this.dataset.getAccess(this.serviceType)) != null) {
            return access.getStandardUrlName();
        }
        return this.dataset.getCatalogUrl();
    }

    @Override
    public String getName() {
        return this.dataset.getName();
    }

    @Override
    public CrawlableDataset getParentDataset() {
        return this.parent;
    }

    @Override
    public boolean exists() {
        return this.catalog != null;
    }

    @Override
    public boolean isCollection() {
        return this.isCollection;
    }

    @Override
    public CrawlableDataset getDescendant(String relativePath) {
        return null;
    }

    @Override
    public List<CrawlableDataset> listDatasets() throws IOException {
        List<InvDataset> datasets = this.dataset.getDatasets();
        ArrayList<CrawlableDataset> result = new ArrayList<CrawlableDataset>();
        for (InvDataset d : datasets) {
            if (!this.filter(d)) continue;
            result.add(new CrawlableCatalog(this, (InvDatasetImpl)d));
        }
        return result;
    }

    @Override
    public List<CrawlableDataset> listDatasets(CrawlableDatasetFilter filter) throws IOException {
        List<InvDataset> datasets = this.dataset.getDatasets();
        ArrayList<CrawlableDataset> result = new ArrayList<CrawlableDataset>();
        for (InvDataset d : datasets) {
            CrawlableCatalog cc;
            if (!this.filter(d) || !filter.accept(cc = new CrawlableCatalog(this, (InvDatasetImpl)d))) continue;
            result.add(cc);
        }
        return result;
    }

    private boolean filter(InvDataset d) {
        if (this.serviceType == null) {
            return true;
        }
        return d.getAccess(this.serviceType) != null;
    }

    @Override
    public long length() {
        double size = this.dataset.getDataSize();
        if (size == 0.0 || Double.isNaN(size)) {
            return 0L;
        }
        return (long)size;
    }

    @Override
    public Date lastModified() {
        DateType dt = this.dataset.getLastModifiedDate();
        return dt == null ? null : dt.getDate();
    }
}

