/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.persistence;

import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.WebApplicationException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.gcube.common.gxhttp.reference.GXConnection;
import org.gcube.common.gxhttp.request.GXHTTPStringRequest;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;
import org.gcube.documentstore.persistence.PersistenceBackend;
import org.gcube.documentstore.persistence.PersistenceBackendConfiguration;
import org.gcube.documentstore.records.DSMapper;
import org.gcube.documentstore.records.Record;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceAccountingService
extends PersistenceBackend {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceAccountingService.class);
    public static final String PATH_SERVICE_INSERT_ACCOUNTING = "/record";
    public static final String APPLICATION_JSON_CHARSET_UTF_8 = "application/json;charset=UTF-8";
    public static final String URL_PROPERTY_KEY = "URL";
    public static final String SERVICE_CLASS = "Accounting";
    public static final String SERVICE_NAME = "AccountingService";
    public static final String SERVICE_ENTRY_NAME = "org.gcube.accounting.service.AccountingResource";
    private static final String USER_AGENT = "document-store-lib-accounting-service";
    private static String FORCED_URL;
    protected String url;
    private static String classFormat;
    private static String nameFormat;
    private static String statusFormat;
    private static String containsFormat;

    private static SimpleQuery queryForService() {
        logger.trace("going to query GCoreEndpoint of {}", (Object)SERVICE_NAME);
        return ICFactory.queryFor(GCoreEndpoint.class).addCondition(String.format(classFormat, SERVICE_CLASS)).addCondition(String.format(nameFormat, SERVICE_NAME)).addCondition(String.format(statusFormat, new Object[0])).addVariable("$entry", "$resource/Profile/AccessPoint/RunningInstanceInterfaces/Endpoint").addCondition(String.format(containsFormat, SERVICE_ENTRY_NAME)).setResult("$entry/text()");
    }

    protected static void forceURL(String url) {
        FORCED_URL = url;
    }

    protected void prepareConnection(PersistenceBackendConfiguration configuration) throws Exception {
        if (FORCED_URL != null) {
            this.url = FORCED_URL;
        } else {
            this.url = configuration.getProperty(URL_PROPERTY_KEY);
            if (this.url == null || this.url.compareTo("") == 0) {
                logger.debug("Invalid URL provided from Configuration. Looking for RunningInstance.");
                SimpleQuery serviceQuery = PersistenceAccountingService.queryForService();
                List addresses = ICFactory.client().submit((Query)serviceQuery);
                if (addresses == null || addresses.isEmpty()) {
                    String error = String.format("No Running Instance %s:%s found in the current context", SERVICE_CLASS, SERVICE_NAME);
                    throw new Exception(error);
                }
                Random random = new Random();
                int index = random.nextInt(addresses.size());
                this.url = (String)addresses.get(index);
            }
        }
        logger.debug("Accounting Service URL to be contacted is {}", (Object)this.url);
    }

    protected StringBuilder getStringBuilder(InputStream inputStream) throws IOException {
        StringBuilder result = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
        }
        return result;
    }

    protected String parseHttpURLConnection(HttpURLConnection connection) throws WebApplicationException {
        try {
            int responseCode = connection.getResponseCode();
            if (connection.getRequestMethod().compareTo(GXConnection.HTTPMETHOD.HEAD.toString()) == 0) {
                if (responseCode == 204) {
                    String string = null;
                    return string;
                }
                if (responseCode == 404) {
                    throw new NotFoundException();
                }
                if (responseCode == 403) {
                    throw new ForbiddenException();
                }
            }
            if (responseCode >= 400) {
                InputStream inputStream = connection.getErrorStream();
                StringBuilder result = this.getStringBuilder(inputStream);
                String res = result.toString();
                throw new WebApplicationException(res, responseCode);
            }
            StringBuilder result = this.getStringBuilder(connection.getInputStream());
            String string = result.toString();
            return string;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
        finally {
            connection.disconnect();
        }
    }

    protected void send(Record ... records) throws Exception {
        List<Record> list = Arrays.asList(records);
        String body = DSMapper.marshal(list);
        logger.trace("Going to persist {}s {}", (Object)Record.class.getSimpleName(), (Object)body);
        GXHTTPStringRequest gxhttpStringRequest = GXHTTPStringRequest.newRequest((String)this.url);
        gxhttpStringRequest.path(PATH_SERVICE_INSERT_ACCOUNTING);
        gxhttpStringRequest.header("Content-Type", APPLICATION_JSON_CHARSET_UTF_8);
        Secret secret = SecretManagerProvider.get();
        Map headers = secret.getHTTPAuthorizationHeaders();
        for (String name : headers.keySet()) {
            gxhttpStringRequest.header(name, (String)headers.get(name));
        }
        gxhttpStringRequest.from(USER_AGENT);
        gxhttpStringRequest.withBody(body);
        HttpURLConnection httpURLConnection = gxhttpStringRequest.post();
        this.parseHttpURLConnection(httpURLConnection);
    }

    protected void reallyAccount(Record record) throws Exception {
        this.send(record);
    }

    protected void accountWithFallback(Record ... records) throws Exception {
        try {
            this.send(records);
        }
        catch (Throwable e) {
            super.accountWithFallback(records);
        }
    }

    public void close() throws Exception {
    }

    protected void openConnection() throws Exception {
    }

    protected void closeConnection() throws Exception {
    }

    public boolean isConnectionActive() throws Exception {
        return true;
    }

    protected void clean() throws Exception {
    }

    static {
        classFormat = "$resource/Profile/ServiceClass/text() eq '%1s'";
        nameFormat = "$resource/Profile/ServiceName/text() eq '%1s'";
        statusFormat = "$resource/Profile/DeploymentData/Status/text() eq 'ready'";
        containsFormat = "$entry/@EntryName eq '%1s'";
    }
}

