/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.security.credentials;

import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gcube.common.keycloak.KeycloakClient;
import org.gcube.common.keycloak.model.ModelUtils;
import org.gcube.common.keycloak.model.TokenResponse;
import org.gcube.common.security.ContextBean;
import org.gcube.common.security.secrets.Secret;
import org.gcube.common.security.secrets.UmaTokenSecret;
import org.gcube.common.validator.annotations.NotEmpty;
import org.gcube.common.validator.annotations.NotNull;
import org.gcube.documentstore.security.credentials.DocumentStoreCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientIdCredentials
implements DocumentStoreCredential {
    private static Logger logger = LoggerFactory.getLogger(ClientIdCredentials.class);
    @NotNull
    @NotEmpty
    String clientID;
    @NotNull
    @NotEmpty
    String secret;

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clientID == null ? 0 : this.clientID.hashCode());
        result = 31 * result + (this.secret == null ? 0 : this.secret.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClientIdCredentials other = (ClientIdCredentials)obj;
        if (this.clientID == null ? other.clientID != null : !this.clientID.equals(other.clientID)) {
            return false;
        }
        return !(this.secret == null ? other.secret != null : !this.secret.equals(other.secret));
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [clientID=" + this.clientID + ", secret=" + this.secret + "]";
    }

    @Override
    public Set<String> getContexts(KeycloakClient client, String endpoint) {
        HashSet<String> contexts = new HashSet<String>();
        try {
            TokenResponse response = null;
            response = endpoint == null || endpoint.isEmpty() ? client.queryOIDCToken(this.getClientID(), this.getSecret()) : client.queryOIDCToken(new URL(endpoint), this.getClientID(), this.getSecret());
            Map resourceAccess = ModelUtils.getAccessTokenFrom((TokenResponse)response).getResourceAccess();
            for (String context : resourceAccess.keySet()) {
                try {
                    ContextBean scope = new ContextBean(context.replaceAll("%2F", "/"));
                    contexts.add(scope.toString());
                    logger.debug("found context {}", (Object)context);
                }
                catch (IllegalArgumentException e) {
                    logger.debug("invalid context found in token: {}", (Object)context);
                }
            }
        }
        catch (Exception e) {
            logger.error("error getting OIDToken from keycloak", (Throwable)e);
            return Collections.emptySet();
        }
        return contexts;
    }

    @Override
    public Secret getSecretForContext(KeycloakClient client, String endpoint, String context) {
        try {
            TokenResponse response = null;
            response = endpoint == null || endpoint.isEmpty() ? client.queryUMAToken(this.getClientID(), this.getSecret(), context, null) : client.queryUMAToken(new URL(endpoint), this.getClientID(), this.getSecret(), context, null);
            return new UmaTokenSecret(response.getAccessToken());
        }
        catch (Exception e) {
            logger.error("error getting OIDToken from keycloak", (Throwable)e);
            throw new RuntimeException("error getting access token for context " + context, e);
        }
    }
}

