/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.lang;

import java.util.Collection;
import org.gcube.io.jsonwebtoken.impl.lang.Converter;
import org.gcube.io.jsonwebtoken.impl.lang.Parameter;
import org.gcube.io.jsonwebtoken.lang.Assert;
import org.gcube.io.jsonwebtoken.lang.Strings;

public class DefaultParameter<T>
implements Parameter<T> {
    private final String ID;
    private final String NAME;
    private final boolean SECRET;
    private final Class<T> IDIOMATIC_TYPE;
    private final Class<? extends Collection<T>> COLLECTION_TYPE;
    private final Converter<T, Object> CONVERTER;

    public DefaultParameter(String id, String name, boolean secret, Class<T> idiomaticType, Class<? extends Collection<T>> collectionType, Converter<T, Object> converter) {
        this.ID = Strings.clean((String)((String)Assert.hasText((CharSequence)id, (String)"ID argument cannot be null or empty.")));
        this.NAME = Strings.clean((String)((String)Assert.hasText((CharSequence)name, (String)"Name argument cannot be null or empty.")));
        this.IDIOMATIC_TYPE = (Class)Assert.notNull(idiomaticType, (String)"idiomaticType argument cannot be null.");
        this.CONVERTER = (Converter)Assert.notNull(converter, (String)"Converter argument cannot be null.");
        this.SECRET = secret;
        this.COLLECTION_TYPE = collectionType;
    }

    public String getId() {
        return this.ID;
    }

    @Override
    public String getName() {
        return this.NAME;
    }

    @Override
    public boolean supports(Object value) {
        if (value == null) {
            return true;
        }
        if (this.COLLECTION_TYPE != null && this.COLLECTION_TYPE.isInstance(value)) {
            Collection<T> c = this.COLLECTION_TYPE.cast(value);
            return c.isEmpty() || this.IDIOMATIC_TYPE.isInstance(c.iterator().next());
        }
        return this.IDIOMATIC_TYPE.isInstance(value);
    }

    @Override
    public T cast(Object value) {
        if (value != null) {
            if (this.COLLECTION_TYPE != null) {
                T element;
                if (!this.COLLECTION_TYPE.isInstance(value)) {
                    String msg = "Cannot cast " + value.getClass().getName() + " to " + this.COLLECTION_TYPE.getName() + "<" + this.IDIOMATIC_TYPE.getName() + ">";
                    throw new ClassCastException(msg);
                }
                Collection<T> c = this.COLLECTION_TYPE.cast(value);
                if (!c.isEmpty() && !this.IDIOMATIC_TYPE.isInstance(element = c.iterator().next())) {
                    String msg = "Cannot cast " + value.getClass().getName() + " to " + this.COLLECTION_TYPE.getName() + "<" + this.IDIOMATIC_TYPE.getName() + ">: At least one " + "element is not an instance of " + this.IDIOMATIC_TYPE.getName();
                    throw new ClassCastException(msg);
                }
            } else if (!this.IDIOMATIC_TYPE.isInstance(value)) {
                String msg = "Cannot cast " + value.getClass().getName() + " to " + this.IDIOMATIC_TYPE.getName();
                throw new ClassCastException(msg);
            }
        }
        return (T)value;
    }

    @Override
    public boolean isSecret() {
        return this.SECRET;
    }

    public int hashCode() {
        return this.ID.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Parameter) {
            return this.ID.equals(((Parameter)obj).getId());
        }
        return false;
    }

    public String toString() {
        return "'" + this.ID + "' (" + this.NAME + ")";
    }

    @Override
    public Object applyTo(T t) {
        return this.CONVERTER.applyTo(t);
    }

    @Override
    public T applyFrom(Object o) {
        return this.CONVERTER.applyFrom(o);
    }
}

