/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.resources.gcore;

import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlType;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gcube.common.resources.gcore.ScopeGroup;

@XmlType(propOrder={"id", "type", "scopes"})
public abstract class Resource {
    private static String CURRENT_VERSION = "0.4.x";
    protected transient Lock lock = new ReentrantLock();
    private static Map<String, Type> types = new HashMap<String, Type>();
    @XmlElement(name="ID")
    private String id = UUID.randomUUID().toString();
    @XmlElementWrapper(name="Scopes")
    @XmlElement(name="Scope")
    private Set<String> scopes = new LinkedHashSet<String>();
    @XmlElement(name="Type")
    private String type;
    @XmlAttribute
    private String version = CURRENT_VERSION;

    public ScopeGroup<String> scopes() {
        return new ScopeGroup<String>(this.scopes, String.class);
    }

    protected String addScope(String scope) {
        this.scopes.add(scope);
        return scope;
    }

    protected String removeScope(String scope) {
        this.scopes.remove(scope);
        return scope;
    }

    public Type type() {
        return Resource.typeOf(this.type);
    }

    protected void type(Type t) {
        this.type = t.toString();
    }

    public String version() {
        return this.version;
    }

    protected void version(String version) {
        this.version = version;
    }

    public String id() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    protected abstract Object profile();

    public String toString() {
        return this.getClass().getSimpleName() + " [id=" + this.id + ", scopes=" + this.scopes + ", type=" + this.type + ", version=" + this.version + ", profile=" + this.profile() + "]";
    }

    private static Type typeOf(String type) {
        return types.get(type);
    }

    void beforeMarshal(Marshaller marshaller) {
        if (this.scopes != null && this.scopes.isEmpty()) {
            this.scopes = null;
        }
    }

    void afterMarshal(Marshaller marshaller) {
        if (this.scopes == null) {
            this.scopes = new LinkedHashSet<String>();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.scopes == null ? 0 : this.scopes.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        result = 31 * result + (this.profile() == null ? 0 : this.profile().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Resource other = (Resource)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.scopes == null ? other.scopes != null : !this.scopes.equals(other.scopes)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
            return false;
        }
        return !(this.profile() == null ? other.profile() != null : !this.profile().equals(other.profile()));
    }

    static {
        for (Type t : Type.values()) {
            types.put(t.toString(), t);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Type {
        GENERIC{

            public String toString() {
                return "GenericResource";
            }
        }
        ,
        ENDPOINT{

            public String toString() {
                return "RuntimeResource";
            }
        }
        ,
        GCOREENDPOINT{

            public String toString() {
                return "RunningInstance";
            }
        }
        ,
        SOFTWARE{

            public String toString() {
                return "Service";
            }
        }
        ,
        NODE{

            public String toString() {
                return "GHN";
            }
        };

    }
}

