/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.records;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.documentstore.exception.InvalidValueException;
import org.gcube.documentstore.records.AggregatedRecord;
import org.gcube.documentstore.records.DSMapper;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.ReflectionUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordUtility {
    private static Logger logger = LoggerFactory.getLogger(RecordUtility.class);
    protected static Set<Package> recordPackages = new HashSet<Package>();
    protected static Map<String, Class<? extends Record>> recordClassesFound = new HashMap<String, Class<? extends Record>>();
    protected static Map<String, Class<? extends AggregatedRecord<?, ?>>> aggregatedRecordClassesFound = new HashMap();
    protected static Map<Class<? extends Record>, Class<? extends AggregatedRecord<?, ?>>> recordAggregationMapping = new HashMap();
    private static final String LINE_FREFIX = "{";
    private static final String LINE_SUFFIX = "}";
    private static final String KEY_VALUE_PAIR_SEPARATOR = ",";
    private static final String KEY_VALUE_LINKER = "=";
    protected static final String INVALID = "invalid";
    private static final String USAGE_RECORD_TYPE = "usageRecordType";

    private RecordUtility() {
    }

    public static void addRecordPackage(Package packageObject) {
        if (recordPackages.contains(packageObject)) {
            logger.trace("Package ({}) already scanned", (Object)packageObject.getName());
            return;
        }
        recordPackages.add(packageObject);
        try {
            List<Class<?>> classes = ReflectionUtility.getClassesForPackage(packageObject);
            for (Class<?> clz : classes) {
                logger.trace("found a class:{}", (Object)clz.getSimpleName());
                if (Record.class.isAssignableFrom(clz)) {
                    RecordUtility.addRecordClass(clz);
                    DSMapper.registerSubtypes(clz);
                }
                if (!AggregatedRecord.class.isAssignableFrom(clz)) continue;
                logger.trace("addAggregatedRecordClass ({}) ", (Object)clz.getName());
                RecordUtility.addAggregatedRecordClass(clz);
                DSMapper.registerSubtypes(clz);
            }
        }
        catch (ClassNotFoundException e) {
            logger.error("Error discovering classes inside package {}", (Object)packageObject.getName(), (Object)e);
        }
    }

    protected static void addRecordClass(Class<? extends Record> cls) {
        if (Modifier.isAbstract(cls.getModifiers())) {
            return;
        }
        try {
            Record record = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (record instanceof AggregatedRecord) {
                return;
            }
            String discoveredRecordType = record.getRecordType();
            if (!recordClassesFound.containsKey(discoveredRecordType)) {
                recordClassesFound.put(discoveredRecordType, cls);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            logger.error("Unable to instantiate found {} class ({})", new Object[]{Record.class.getSimpleName(), cls.getSimpleName(), e});
            return;
        }
    }

    protected static void addAggregatedRecordClass(Class<? extends AggregatedRecord<?, ?>> cls) {
        if (Modifier.isAbstract(cls.getModifiers())) {
            return;
        }
        try {
            AggregatedRecord<?, ?> instance = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            String discoveredRecordType = instance.getRecordType();
            if (!aggregatedRecordClassesFound.containsKey(discoveredRecordType)) {
                logger.trace("discoveredRecordType not found:" + discoveredRecordType + " with cls:" + cls.getName());
                aggregatedRecordClassesFound.put(discoveredRecordType, cls);
                Class<?> recordClass = instance.getAggregable();
                recordAggregationMapping.put(recordClass, cls);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            logger.error("Unable to instantiate found {} class ({})", new Object[]{AggregatedRecord.class.getSimpleName(), cls.getSimpleName(), e});
            return;
        }
    }

    public static Map<String, Class<? extends Record>> getRecordClassesFound() {
        return recordClassesFound;
    }

    public static Map<String, Class<? extends AggregatedRecord<?, ?>>> getAggregatedRecordClassesFound() {
        return aggregatedRecordClassesFound;
    }

    public static Class<? extends AggregatedRecord<?, ?>> getAggregatedRecordClass(String recordType) throws ClassNotFoundException {
        if (RecordUtility.getAggregatedRecordClassesFound().containsKey(recordType)) {
            return RecordUtility.getAggregatedRecordClassesFound().get(recordType);
        }
        logger.error("Unable to find {} class for {}.", (Object)AggregatedRecord.class.getSimpleName(), (Object)recordType);
        logger.debug("getAggregatedRecordClass getAggregatedRecordClassesFound:" + String.valueOf(RecordUtility.getAggregatedRecordClassesFound()));
        throw new ClassNotFoundException();
    }

    public static Class<? extends Record> getRecordClass(String recordType) throws ClassNotFoundException {
        if (recordClassesFound.containsKey(recordType)) {
            return recordClassesFound.get(recordType);
        }
        logger.error("Unable to find {} class for {}.", (Object)Record.class.getSimpleName(), (Object)recordType);
        throw new ClassNotFoundException();
    }

    protected static Class<? extends Record> getClass(String recordType, boolean aggregated) throws ClassNotFoundException {
        if (aggregated) {
            return RecordUtility.getAggregatedRecordClass(recordType);
        }
        return RecordUtility.getRecordClass(recordType);
    }

    protected static Map<String, ? extends Serializable> getMapFromString(String serializedMap) {
        if (!serializedMap.startsWith(LINE_FREFIX) && !serializedMap.endsWith(LINE_SUFFIX)) {
            return null;
        }
        serializedMap = serializedMap.replace(LINE_FREFIX, "");
        serializedMap = serializedMap.replace(LINE_SUFFIX, "");
        HashMap<String, String> map = new HashMap<String, String>();
        String[] pairs = serializedMap.split(KEY_VALUE_PAIR_SEPARATOR);
        for (int i = 0; i < pairs.length; ++i) {
            String pair = pairs[i];
            pair.trim();
            String[] keyValue = pair.split(KEY_VALUE_LINKER);
            String key = keyValue[0].trim();
            String value = keyValue[1].trim();
            map.put(key, value);
        }
        return map;
    }

    public static <R extends Record> R getRecord(String jsonString) throws Exception {
        try {
            JsonNode jsonNode = DSMapper.asJsonNode(jsonString);
            if (jsonNode.has(USAGE_RECORD_TYPE)) {
                jsonString = jsonString.replace(USAGE_RECORD_TYPE, "recordType");
            }
            logger.trace("Going to unmarshall {} using jackson", (Object)jsonString);
            return (R)DSMapper.unmarshal(Record.class, jsonString);
        }
        catch (Exception ex) {
            logger.trace("Going to unmarshall {} as serialized Map", (Object)jsonString);
            Map<String, ? extends Serializable> map = RecordUtility.getMapFromString(jsonString);
            if (map != null) {
                Record record = RecordUtility.getRecord(map);
                try {
                    record.validate();
                }
                catch (InvalidValueException e) {
                    record.setResourceProperty(INVALID, Boolean.valueOf(true));
                    logger.error("Recovered record is not valid. Anyway, it will be persisted", (Throwable)e);
                }
                return (R)record;
            }
            return null;
        }
    }

    public static Record getRecord(Map<String, ? extends Serializable> recordMap) throws Exception {
        String className = (String)((Object)recordMap.get("recordType"));
        if (className == null) {
            className = (String)((Object)recordMap.get(USAGE_RECORD_TYPE));
            recordMap.put("recordType", (Serializable)((Object)className));
        }
        boolean aggregated = false;
        try {
            aggregated = (Boolean)recordMap.get("aggregated");
        }
        catch (Exception e) {
            try {
                aggregated = Boolean.parseBoolean((String)((Object)recordMap.get("aggregated")));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Class<? extends Record> clz = RecordUtility.getClass(className, aggregated);
        Class[] usageRecordArgTypes = new Class[]{Map.class};
        Constructor<? extends Record> usageRecordConstructor = clz.getDeclaredConstructor(usageRecordArgTypes);
        Object[] usageRecordArguments = new Object[]{recordMap};
        Record record = usageRecordConstructor.newInstance(usageRecordArguments);
        return record;
    }
}

