/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.resources.gcore.common;

import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlMixed;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.gcube.common.resources.gcore.utils.Utils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AnyMixedWrapper {
    private Element root = Utils.newDocument().getDocumentElement();
    @XmlAnyElement
    @XmlMixed
    private List<Object> nodes;
    private static TransformerFactory tFactory = TransformerFactory.newInstance();

    public Element root() {
        Node child;
        Element response = this.root;
        NodeList list = this.root.getChildNodes();
        if (list.getLength() == 1 && (child = list.item(0)) instanceof Element) {
            response = (Element)child;
        }
        return response;
    }

    public String asString() {
        StringBuilder builder = new StringBuilder();
        NodeList list = this.root.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            if (child instanceof Element) {
                builder.append(AnyMixedWrapper.toString(child));
                continue;
            }
            builder.append(child.getTextContent());
        }
        return builder.toString();
    }

    public void setString(String text) {
        try {
            for (Node node : Utils.parse(text)) {
                this.root.appendChild(this.root.getOwnerDocument().importNode(node, true));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("cannot add " + text + " to this resource as it violates well-formedness constraints", e);
        }
    }

    private void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
        if (this.nodes != null) {
            boolean mixedContent = false;
            for (Object node : this.nodes) {
                if (!(node instanceof String) || ((String)String.class.cast(node)).matches("\\s*")) continue;
                mixedContent = true;
                break;
            }
            for (Object node : this.nodes) {
                if (node instanceof Element) {
                    this.root.appendChild(this.root.getOwnerDocument().adoptNode((Element)node));
                    continue;
                }
                if (!mixedContent) continue;
                this.root.appendChild(this.root.getOwnerDocument().createTextNode((String)node));
            }
        }
        this.nodes = null;
    }

    private void beforeMarshal(Marshaller marshaller) {
        this.nodes = new ArrayList<Object>();
        NodeList list = this.root.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() == 1) {
                this.nodes.add((Element)node);
                continue;
            }
            this.nodes.add(node.getTextContent());
        }
    }

    public String toString() {
        return "[element=" + String.valueOf(this.root) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.root == null ? 0 : this.root.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnyMixedWrapper other = (AnyMixedWrapper)obj;
        if (this.root != null && other.root != null) {
            this.root.normalize();
            other.root.normalize();
        }
        return !(this.root == null ? other.root != null : !this.root.isEqualNode(other.root));
    }

    private static String toString(Node tree) {
        try {
            String nodeString = null;
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(tree);
            transformer.transform(source, result);
            nodeString = sw.getBuffer().toString();
            return nodeString;
        }
        catch (Exception e) {
            throw new RuntimeException("cannot convert DOM to string", e);
        }
    }
}

