/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.keycloak.oidc.avatar.importer;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.gcube.keycloak.avatar.storage.AvatarStorageProvider;
import org.gcube.keycloak.oidc.avatar.importer.libravatar.Libravatar;
import org.gcube.keycloak.oidc.avatar.importer.libravatar.LibravatarDefaultImage;
import org.gcube.keycloak.oidc.avatar.importer.libravatar.LibravatarException;
import org.gcube.keycloak.oidc.avatar.importer.libravatar.LibravatarOptions;
import org.jboss.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.keycloak.broker.oidc.mappers.AbstractClaimMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderSyncMode;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;

public class AvatarImporter
extends AbstractClaimMapper {
    private static final Logger logger = Logger.getLogger(AvatarImporter.class);
    public static final String[] PROVIDERS_WITH_PICTURE_CLAIM = new String[]{"google", "oidc", "keycloak-oidc"};
    public static final String[] PROVIDERS_WITH_SPECIFIC_CODE = new String[]{"facebook", "linkedin-openid-connect"};
    public static final String[] COMPATIBLE_PROVIDERS = (String[])ArrayUtils.addAll((Object[])PROVIDERS_WITH_PICTURE_CLAIM, (Object[])PROVIDERS_WITH_SPECIFIC_CODE);
    private static final List<ProviderConfigProperty> configProperties;
    private static final Set<IdentityProviderSyncMode> IDENTITY_PROVIDER_SYNC_MODES;
    public static final Integer DEFAULT_AVATAR_SIZE;
    public static final String USE_LIBRAVATAR_PROPERTY = "use-libravatar";
    public static final String FORK_IMPORT_THREAD_PROPERTY = "import-with-thread";
    public static final String MAPPER_ID = "avatar-importer";

    public boolean supportsSyncMode(IdentityProviderSyncMode syncMode) {
        return IDENTITY_PROVIDER_SYNC_MODES.contains(syncMode);
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return MAPPER_ID;
    }

    public String[] getCompatibleProviders() {
        return COMPATIBLE_PROVIDERS;
    }

    public String getDisplayCategory() {
        return "Preprocessor";
    }

    public String getDisplayType() {
        return "Avatar importer";
    }

    public void updateBrokeredUserLegacy(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        logger.debug((Object)"Importing avatar for brokered user legacy");
        this.importNewUser(session, realm, user, mapperModel, context);
    }

    public void updateBrokeredUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        logger.debug((Object)"Importing avatar for brokered user");
        this.importNewUser(session, realm, user, mapperModel, context);
    }

    public void importNewUser(final KeycloakSession session, final RealmModel realm, final UserModel user, IdentityProviderMapperModel mapperModel, final BrokeredIdentityContext context) {
        final boolean useLibravatar = Boolean.valueOf((String)mapperModel.getConfig().get(USE_LIBRAVATAR_PROPERTY));
        boolean forkNewThread = Boolean.valueOf((String)mapperModel.getConfig().get(FORK_IMPORT_THREAD_PROPERTY));
        final String identityProviderAlias = mapperModel.getIdentityProviderAlias();
        Runnable importAvatarRunnable = new Runnable(){

            @Override
            public void run() {
                AvatarStorageProvider avatarStorageProvider = (AvatarStorageProvider)session.getProvider(AvatarStorageProvider.class);
                if (avatarStorageProvider == null) {
                    logger.warn((Object)"Cannot perform avatar import since the avatar storage provider is null");
                    return;
                }
                InputStream avatarInputStream = null;
                if (ArrayUtils.contains((Object[])PROVIDERS_WITH_PICTURE_CLAIM, (Object)identityProviderAlias)) {
                    String imageClaim = (String)AbstractClaimMapper.getClaimValue((BrokeredIdentityContext)context, (String)"picture");
                    if (imageClaim != null && !"".equals(imageClaim)) {
                        logger.infof("Getting avatar from token claim. Value is: %s", (Object)imageClaim);
                        try {
                            avatarInputStream = new URL(imageClaim).openStream();
                        }
                        catch (IOException e) {
                            logger.info((Object)("Cannot load avatar image from claim: " + imageClaim), (Throwable)e);
                        }
                    }
                } else if ("linkedin-openid-connect".equals(identityProviderAlias)) {
                    avatarInputStream = AvatarImporter.this.loadAvatarFromLinkedIn(context);
                } else if ("facebook".equals(identityProviderAlias)) {
                    avatarInputStream = AvatarImporter.this.loadAvatarFromFacebook(context);
                }
                if (avatarInputStream == null) {
                    if (useLibravatar) {
                        logger.debugf("Trying getting avatar from libravatar service", new Object[0]);
                        String email = user.getEmail();
                        try {
                            avatarInputStream = Libravatar.from(email).withOptions(new LibravatarOptions().withHttps().defaultingTo(LibravatarDefaultImage.NOT_FOUND).withImageSize(DEFAULT_AVATAR_SIZE)).download();
                        }
                        catch (LibravatarException e) {
                            logger.infof("Avatar not found via libravatar for email: %s", (Object)email);
                        }
                    } else {
                        logger.debug((Object)"Skipped search on libravatar due to mapper configuration");
                    }
                }
                if (avatarInputStream != null) {
                    logger.debug((Object)"Saving the image via avatar storage provider");
                    avatarStorageProvider.saveAvatarImage(realm, user, avatarInputStream);
                } else {
                    logger.debugf("No avatar found for user: %s", (Object)user);
                }
            }
        };
        if (forkNewThread) {
            logger.debug((Object)"Forking new thread to perform the avatar import");
            new Thread(importAvatarRunnable, "oidc-avatar-import").start();
        } else {
            logger.debug((Object)"Performing the avatar import in the same thread");
            importAvatarRunnable.run();
        }
    }

    private InputStream loadAvatarFromLinkedIn(BrokeredIdentityContext context) {
        logger.info((Object)"Getting avatar from LinkedIn profile picture prjection");
        try {
            JSONObject displayImageProjection = (JSONObject)new JSONParser().parse((Reader)new InputStreamReader(new URL("https://api.linkedin.com/v2/me?projection=(profilePicture(displayImage~:playableStreams))&oauth2_access_token=" + this.getAccessTokenString(context)).openStream()));
            String imageURL = null;
            for (JSONObject element : (JSONArray)((JSONObject)((JSONObject)displayImageProjection.get((Object)"profilePicture")).get((Object)"displayImage~")).get((Object)"elements")) {
                if ((Double)((JSONObject)((JSONObject)((JSONObject)element.get((Object)"data")).get((Object)"com.linkedin.digitalmedia.mediaartifact.StillImage")).get((Object)"displaySize")).get((Object)"width") != 100.0) continue;
                imageURL = (String)((JSONObject)((JSONArray)element.get((Object)"identifiers")).get(0)).get((Object)"identifier");
            }
            if (imageURL != null) {
                logger.infof("Opening stream connnection to %s", imageURL);
                return new URL(imageURL).openStream();
            }
        }
        catch (IOException | ParseException e) {
            logger.info((Object)"Cannot load LinkedIn avatar image from projection", e);
        }
        return null;
    }

    protected InputStream loadAvatarFromFacebook(BrokeredIdentityContext context) {
        logger.info((Object)"Getting avatar from Facebook Graph API call");
        try {
            return new URL(String.format("https://graph.facebook.com/%s/picture?type=normal", context.getId())).openStream();
        }
        catch (IOException e) {
            logger.info((Object)"Cannot load Facebook avatar image from Graph API", (Throwable)e);
            return null;
        }
    }

    protected String getAccessTokenString(BrokeredIdentityContext context) {
        return (String)context.getContextData().get("FEDERATED_ACCESS_TOKEN");
    }

    public void preprocessFederatedIdentity(KeycloakSession session, RealmModel realm, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
    }

    public String getHelpText() {
        return "Import the IdP avatar image or use the libravatr service to find it.";
    }

    static {
        IDENTITY_PROVIDER_SYNC_MODES = new HashSet<IdentityProviderSyncMode>(Arrays.asList(IdentityProviderSyncMode.values()));
        DEFAULT_AVATAR_SIZE = 160;
        configProperties = ProviderConfigurationBuilder.create().property().name(USE_LIBRAVATAR_PROPERTY).label("Use Libravatar service").helpText("If the provider not provide the image claim, the email is used to search the avatar by using libravatar service.").defaultValue((Object)Boolean.TRUE).type("boolean").add().property().name(FORK_IMPORT_THREAD_PROPERTY).label("Import avatar in a separate thread").helpText("Import the avatar by forking a new thread and don't wait the end of import.").defaultValue((Object)Boolean.FALSE).type("boolean").add().build();
    }
}

