/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.keycloak.avatar.storage.file;

import org.gcube.keycloak.avatar.storage.AvatarStorageProvider;
import org.gcube.keycloak.avatar.storage.AvatarStorageProviderFactory;
import org.gcube.keycloak.avatar.storage.file.FileAvatarStorageProvider;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;

public class FileAvatarStorageProviderFactory
implements AvatarStorageProviderFactory {
    public static final String DEFAULT_AVATAR_FOLDER = (System.getProperty("jboss.server.data.dir") != null ? System.getProperty("jboss.server.data.dir") : System.getProperty("user.home")) + "/avatar";
    public static final Boolean USE_EMAIL_AS_FILENAME_DEFAULT = Boolean.FALSE;
    private String avatarFolder;
    private Boolean useEmailAsFilename;

    public AvatarStorageProvider create(KeycloakSession session) {
        return new FileAvatarStorageProvider(this.avatarFolder, this.useEmailAsFilename);
    }

    public void init(Config.Scope config) {
        this.avatarFolder = config.get("avatar-folder", DEFAULT_AVATAR_FOLDER);
        this.useEmailAsFilename = config.getBoolean("use-email-as-filename", USE_EMAIL_AS_FILENAME_DEFAULT);
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "avatar-storage-file";
    }
}

