/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.keycloak.protocol.oidc;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.keycloak.protocol.oidc.representations.OIDCConfigurationRepresentation;

public class Utils {
    public static String getIntrospectionEndpoint(String issuerUrl) {
        try {
            Object wellKnownUrl = issuerUrl;
            if (!((String)wellKnownUrl).endsWith("/")) {
                wellKnownUrl = (String)wellKnownUrl + "/";
            }
            wellKnownUrl = (String)wellKnownUrl + ".well-known/openid-configuration";
            URL url = new URL((String)wellKnownUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Accept", "application/json");
            int status = connection.getResponseCode();
            if (status == 200) {
                InputStream inputStream = connection.getInputStream();
                ObjectMapper mapper = new ObjectMapper();
                OIDCConfigurationRepresentation config = (OIDCConfigurationRepresentation)mapper.readValue(inputStream, OIDCConfigurationRepresentation.class);
                return config.getIntrospectionEndpoint();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

