package elasticsearchindex.helpers;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map.Entry;

import org.elasticsearch.common.text.Text;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.highlight.HighlightField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import edu.emory.mathcs.backport.java.util.Collections;

public class SnippetsHelper {
	private static final Logger logger = LoggerFactory.getLogger(SnippetsHelper.class);

	private static final SnippetsComparator snippetsComparator = new SnippetsComparator();
	private static final String SNIPPET_TOKEN = "...";

	private static class SnippetsComparator implements Comparator<String> {
		@Override
		public int compare(String o1, String o2) {
			return o1.length() - o2.length();
		}
	}

	public static String createSnippetString(SearchHit hit, int maxSnippetCount) {
		int snippetsCnt = 0;
		List<String> snippets = new ArrayList<String>();

		logger.info("Creating snippets for hit : " + hit);

		for (Entry<String, HighlightField> snippet : hit.getHighlightFields().entrySet())
			if (snippet.getValue() != null && snippet.getValue().getFragments() != null)
				for (Text text : snippet.getValue().getFragments())
					snippets.add(text.string());

		logger.info("snippets found : " + snippets);

		Collections.sort(snippets, snippetsComparator);

		StringBuilder strb = new StringBuilder();
		for (String s : snippets) {
			strb.append(s);
			strb.append(SNIPPET_TOKEN);
			snippetsCnt++;
			if (snippetsCnt >= maxSnippetCount)
				return strb.toString();
		}

		logger.info("snippets string : " + strb.toString());

		return strb.toString();
	}
}
