/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.schema;

import org.gcube.informationsystem.resourceregistry.api.rest.ServiceInstance;
import org.gcube.informationsystem.resourceregistry.schema.ResourceRegistrySchemaClient;
import org.gcube.informationsystem.resourceregistry.schema.ResourceRegistrySchemaClientImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistrySchemaClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRegistrySchemaClientFactory.class);

    public static String getResourceRegistryURL() {
        String address = "%s/%s".formatted(ServiceInstance.getServiceURL(), "resource-registry");
        return address;
    }

    public static String getResourceRegistryURL(String context) {
        String address = "%s/%s".formatted(ServiceInstance.getServiceURL((String)context), "resource-registry");
        return address;
    }

    public static ResourceRegistrySchemaClient create() {
        String address = ResourceRegistrySchemaClientFactory.getResourceRegistryURL();
        logger.trace("The {} will be contacted at {}", (Object)"resource-registry", (Object)address);
        return new ResourceRegistrySchemaClientImpl(address);
    }

    public static ResourceRegistrySchemaClient create(String context) {
        String address = ResourceRegistrySchemaClientFactory.getResourceRegistryURL(context);
        logger.trace("The {} will be contacted at {}", (Object)"resource-registry", (Object)address);
        return new ResourceRegistrySchemaClientImpl(address);
    }
}

