package org.gcube.portal.event.publisher.lr74.action;

import com.liferay.portal.kernel.events.LifecycleAction;
import com.liferay.portal.kernel.events.LifecycleEvent;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import org.osgi.service.component.annotations.Component;

@Component(
    immediate = true,
    service = LifecycleAction.class,
    property = {
        "key=application.startup.events"
    }
)
public class StartupAction implements LifecycleAction {

    private static final Log _log = LogFactoryUtil.getLog(StartupAction.class);

    @Override
    public void processLifecycleEvent(LifecycleEvent lifecycleEvent) {
        _log.info("[EventPublisher] StartupAction invoked");
        try {
            // Delegate to facade to preserve legacy semantics
            org.gcube.portal.event.publisher.lr74.model.EventPublisherFacade.getInstance()
                .onStartup();
        } catch (Exception e) {
            _log.error("StartupAction failed", e);
        }
    }
}