/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server.amservice;

import java.util.ArrayList;
import java.util.List;
import org.gcube.accounting.analytics.Info;
import org.gcube.accounting.analytics.ResourceRecordQuery;
import org.gcube.accounting.datamodel.aggregation.AggregatedServiceUsageRecord;
import org.gcube.accounting.datamodel.aggregation.AggregatedStorageUsageRecord;
import org.gcube.portlets.admin.accountingmanager.server.amservice.AccountingCaller;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQuery;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQuery4Job;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQuery4Portlet;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQuery4Service;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQuery4Storage;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQuery4Task;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQueryBuilder;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQueryDirector;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponse4Job;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponse4Portlet;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponse4Service;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponse4Storage;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponse4Task;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponseBuilder;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponseDirector;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingType;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterKey;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterValue;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterValuesRequest;
import org.gcube.portlets.admin.accountingmanager.shared.data.query.SeriesRequest;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesResponse;
import org.gcube.portlets.admin.accountingmanager.shared.exception.AccountingManagerServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingCaller {
    private static Logger logger = LoggerFactory.getLogger(AccountingCaller.class);

    public ArrayList<FilterKey> getFilterKeys(AccountingType accountingType) throws AccountingManagerServiceException {
        try {
            List keys;
            logger.debug("getFilterKeys(): [AccountingType=" + accountingType + "]");
            if (accountingType == null) {
                return new ArrayList<FilterKey>();
            }
            ArrayList<FilterKey> filterKeys = new ArrayList<FilterKey>();
            ResourceRecordQuery rrq = new ResourceRecordQuery();
            switch (1.$SwitchMap$org$gcube$portlets$admin$accountingmanager$shared$data$AccountingType[accountingType.ordinal()]) {
                case 1: {
                    return filterKeys;
                }
                case 2: {
                    return filterKeys;
                }
                case 3: {
                    keys = rrq.getKeys(AggregatedServiceUsageRecord.class);
                    break;
                }
                case 4: {
                    keys = rrq.getKeys(AggregatedStorageUsageRecord.class);
                    break;
                }
                case 5: {
                    return filterKeys;
                }
                default: {
                    return filterKeys;
                }
            }
            for (String key : keys) {
                if (key == null || key.isEmpty()) continue;
                filterKeys.add(new FilterKey(key));
            }
            return filterKeys;
        }
        catch (Throwable e) {
            logger.error("Error in getFilterKeys(): " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new AccountingManagerServiceException("No keys available!");
        }
    }

    public ArrayList<FilterValue> getFilterValues(FilterValuesRequest filterValuesRequest) throws AccountingManagerServiceException {
        try {
            List values;
            logger.debug("getFilterValue(): [FilterValueRequest=" + filterValuesRequest + "]");
            if (filterValuesRequest == null || filterValuesRequest.getAccountingType() == null || filterValuesRequest.getFilterKey() == null) {
                return new ArrayList<FilterValue>();
            }
            ArrayList<FilterValue> filteValues = new ArrayList<FilterValue>();
            ResourceRecordQuery rrq = new ResourceRecordQuery();
            switch (1.$SwitchMap$org$gcube$portlets$admin$accountingmanager$shared$data$AccountingType[filterValuesRequest.getAccountingType().ordinal()]) {
                case 1: {
                    return filteValues;
                }
                case 2: {
                    return filteValues;
                }
                case 3: {
                    values = rrq.getPossibleValuesForKey(AggregatedServiceUsageRecord.class, filterValuesRequest.getFilterKey().getKey());
                    break;
                }
                case 4: {
                    values = rrq.getPossibleValuesForKey(AggregatedStorageUsageRecord.class, filterValuesRequest.getFilterKey().getKey());
                    break;
                }
                case 5: {
                    return filteValues;
                }
                default: {
                    return filteValues;
                }
            }
            for (String value : values) {
                if (value == null || value.isEmpty()) continue;
                filteValues.add(new FilterValue(value));
            }
            return filteValues;
        }
        catch (Throwable e) {
            logger.error("Error in getFilterValues(): " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new AccountingManagerServiceException("No values available!");
        }
    }

    public SeriesResponse getSeries(AccountingType accountingType, SeriesRequest seriesRequest) throws AccountingManagerServiceException {
        try {
            logger.debug("getSeries(): [AccountingType=" + accountingType + " , seriesRequest=" + seriesRequest + "]");
            ResourceRecordQuery rrq = new ResourceRecordQuery();
            AccountingQueryBuilder queryBuilder = this.getAccountQueryBuilder(accountingType, seriesRequest);
            AccountingQueryDirector director = new AccountingQueryDirector();
            director.setAccountingQueryBuilder(queryBuilder);
            director.constructAccountingQuery();
            AccountingQuery query = director.getAccountingQuery();
            if (query == null) {
                throw new AccountingManagerServiceException("Error in invocation: Operation not supported");
            }
            logger.debug("Query: " + query);
            List infos = rrq.getInfo(query.getType(), query.getTemporalConstraint(), (List)query.getFilters(), true);
            if (infos == null) {
                throw new AccountingManagerServiceException("Error retrieving list of info: list is null!");
            }
            logger.debug("Retrieved Infos");
            logger.debug("Infos: " + infos);
            SeriesResponseBuilder seriesResponseBuilder = this.getSeriesResponseBuilder(accountingType, infos);
            SeriesResponseDirector seriesResponseDirector = new SeriesResponseDirector();
            seriesResponseDirector.setSeriesResponseBuilder(seriesResponseBuilder);
            seriesResponseDirector.constructSeriesResponse();
            SeriesResponse seriesResponse = seriesResponseDirector.getSeriesResponse();
            if (seriesResponse == null) {
                throw new AccountingManagerServiceException("Error creating series response!");
            }
            logger.debug("SeriesResponse Created: " + seriesResponse);
            return seriesResponse;
        }
        catch (Throwable e) {
            logger.error("Error in GetSeries(): " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new AccountingManagerServiceException("No data available!");
        }
    }

    private AccountingQueryBuilder getAccountQueryBuilder(AccountingType accountingType, SeriesRequest seriesRequest) throws AccountingManagerServiceException {
        if (accountingType == null) {
            throw new AccountingManagerServiceException("Error accounting type is null");
        }
        logger.debug("StartCalendar: " + seriesRequest.getAccountingPeriod().getStartDate());
        logger.debug("EndCalendar: " + seriesRequest.getAccountingPeriod().getEndDate());
        switch (1.$SwitchMap$org$gcube$portlets$admin$accountingmanager$shared$data$AccountingType[accountingType.ordinal()]) {
            case 1: {
                return new AccountingQuery4Job(seriesRequest);
            }
            case 2: {
                return new AccountingQuery4Portlet(seriesRequest);
            }
            case 3: {
                return new AccountingQuery4Service(seriesRequest);
            }
            case 4: {
                return new AccountingQuery4Storage(seriesRequest);
            }
            case 5: {
                return new AccountingQuery4Task(seriesRequest);
            }
        }
        throw new AccountingManagerServiceException("Error request type is unknow!");
    }

    private SeriesResponseBuilder getSeriesResponseBuilder(AccountingType accountingType, List<Info> infos) throws AccountingManagerServiceException {
        if (accountingType == null) {
            throw new AccountingManagerServiceException("Error accounting type is null");
        }
        switch (1.$SwitchMap$org$gcube$portlets$admin$accountingmanager$shared$data$AccountingType[accountingType.ordinal()]) {
            case 1: {
                return new SeriesResponse4Job(infos);
            }
            case 2: {
                return new SeriesResponse4Portlet(infos);
            }
            case 3: {
                return new SeriesResponse4Service(infos);
            }
            case 4: {
                return new SeriesResponse4Storage(infos);
            }
            case 5: {
                return new SeriesResponse4Task(infos);
            }
        }
        throw new AccountingManagerServiceException("Error request type is unknow!");
    }
}

