package org.gcube.portlets.admin.accountingmanager.server.amservice;

import java.util.ArrayList;
import java.util.List;

import org.gcube.accounting.analytics.Info;
import org.gcube.accounting.analytics.ResourceRecordQuery;
import org.gcube.accounting.datamodel.aggregation.AggregatedServiceUsageRecord;
import org.gcube.accounting.datamodel.aggregation.AggregatedStorageUsageRecord;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQuery;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQuery4Job;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQuery4Portlet;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQuery4Service;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQuery4Storage;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQuery4Task;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQueryBuilder;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQueryDirector;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponse4Job;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponse4Portlet;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponse4Service;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponse4Storage;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponse4Task;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponseBuilder;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponseDirector;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingType;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterKey;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterValue;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterValuesRequest;
import org.gcube.portlets.admin.accountingmanager.shared.data.query.SeriesRequest;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesResponse;
import org.gcube.portlets.admin.accountingmanager.shared.exception.AccountingManagerServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author giancarlo email: <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 *
 */
public class AccountingCaller {
	private static Logger logger = LoggerFactory
			.getLogger(AccountingCaller.class);

	public AccountingCaller() {

	}

	public ArrayList<FilterKey> getFilterKeys(AccountingType accountingType)
			throws AccountingManagerServiceException {
		try {
			logger.debug("getFilterKeys(): [AccountingType=" + accountingType
					+ "]");
			if (accountingType == null) {
				return new ArrayList<FilterKey>();
			}
			ArrayList<FilterKey> filterKeys = new ArrayList<FilterKey>();
			List<String> keys;

			ResourceRecordQuery rrq = new ResourceRecordQuery();

			switch (accountingType) {
			case JOB:
				// keys=rrq.getKeys(AggregatedJobUsageRecord.class);
				return filterKeys;
			case PORTLET:
				// keys=rrq.getKeys(AggregatedPortletUsageRecord.class);
				return filterKeys;
			case SERVICE:
				keys = rrq.getKeys(AggregatedServiceUsageRecord.class);
				break;
			case STORAGE:
				keys = rrq.getKeys(AggregatedStorageUsageRecord.class);
				break;
			case TASK:
				// keys=rrq.getKeys(AggregatedTaskUsageRecord.class);
				return filterKeys;
			default:
				return filterKeys;
			}
			for (String key : keys) {
				if (key != null && !key.isEmpty()) {
					filterKeys.add(new FilterKey(key));
				}
			}

			return filterKeys;
		} catch (Throwable e) {
			logger.error("Error in getFilterKeys(): " + e.getLocalizedMessage());
			e.printStackTrace();
			throw new AccountingManagerServiceException("No keys available!");

		}
	}

	public ArrayList<FilterValue> getFilterValues(
			FilterValuesRequest filterValuesRequest)
			throws AccountingManagerServiceException {
		try {
			logger.debug("getFilterValue(): [FilterValueRequest="
					+ filterValuesRequest + "]");
			if (filterValuesRequest == null
					|| filterValuesRequest.getAccountingType() == null
					|| filterValuesRequest.getFilterKey() == null) {
				return new ArrayList<FilterValue>();
			}

			ArrayList<FilterValue> filteValues = new ArrayList<FilterValue>();
			List<String> values;

			ResourceRecordQuery rrq = new ResourceRecordQuery();

			switch (filterValuesRequest.getAccountingType()) {
			case JOB:
				// values =
				// rrq.getPossibleValuesForKey(AggregatedJobUsageRecord.class,
				// filterValuesRequest
				// .getFilterKey().getKey());
				return filteValues;
			case PORTLET:
				// values = rrq.getPossibleValuesForKey(
				// AggregatedPortletUsageRecord.class, filterValuesRequest
				// .getFilterKey().getKey());
				return filteValues;
			case SERVICE:
				values = rrq.getPossibleValuesForKey(
						AggregatedServiceUsageRecord.class, filterValuesRequest
								.getFilterKey().getKey());
				break;
			case STORAGE:
				values = rrq.getPossibleValuesForKey(
						AggregatedStorageUsageRecord.class, filterValuesRequest
								.getFilterKey().getKey());
				break;
			case TASK:
				// values = rrq.getPossibleValuesForKey(
				// AggregatedTaskUsageRecord.class, filterValuesRequest
				// .getFilterKey().getKey());
				return filteValues;
			default:
				return filteValues;
			}
			for (String value : values) {
				if (value != null && !value.isEmpty()) {
					filteValues.add(new FilterValue(value));
				}
			}

			return filteValues;
		} catch (Throwable e) {
			logger.error("Error in getFilterValues(): "
					+ e.getLocalizedMessage());
			e.printStackTrace();
			throw new AccountingManagerServiceException("No values available!");

		}
	}

	public SeriesResponse getSeries(AccountingType accountingType,
			SeriesRequest seriesRequest)
			throws AccountingManagerServiceException {
		try {
			logger.debug("getSeries(): [AccountingType=" + accountingType
					+ " , seriesRequest=" + seriesRequest + "]");

			ResourceRecordQuery rrq = new ResourceRecordQuery();

			AccountingQueryBuilder queryBuilder = getAccountQueryBuilder(
					accountingType, seriesRequest);

			AccountingQueryDirector director = new AccountingQueryDirector();
			director.setAccountingQueryBuilder(queryBuilder);
			director.constructAccountingQuery();
			AccountingQuery query = director.getAccountingQuery();

			if (query == null) {
				throw new AccountingManagerServiceException(
						"Error in invocation: Operation not supported");
			}

			logger.debug("Query: " + query);

			List<Info> infos = rrq.getInfo(query.getType(),
					query.getTemporalConstraint(), query.getFilters(), true);
			if (infos == null) {
				throw new AccountingManagerServiceException(
						"Error retrieving list of info: list is null!");
			}
			logger.debug("Retrieved Infos");
			logger.debug("Infos: " + infos);

			SeriesResponseBuilder seriesResponseBuilder = getSeriesResponseBuilder(
					accountingType, infos);

			SeriesResponseDirector seriesResponseDirector = new SeriesResponseDirector();
			seriesResponseDirector
					.setSeriesResponseBuilder(seriesResponseBuilder);
			seriesResponseDirector.constructSeriesResponse();
			SeriesResponse seriesResponse = seriesResponseDirector
					.getSeriesResponse();

			if (seriesResponse == null) {
				throw new AccountingManagerServiceException(
						"Error creating series response!");
			}
			logger.debug("SeriesResponse Created: " + seriesResponse);
			return seriesResponse;
		} catch (Throwable e) {
			logger.error("Error in GetSeries(): " + e.getLocalizedMessage());
			e.printStackTrace();
			throw new AccountingManagerServiceException("No data available!");

		}
	}

	private AccountingQueryBuilder getAccountQueryBuilder(
			AccountingType accountingType, SeriesRequest seriesRequest)
			throws AccountingManagerServiceException {
		if (accountingType == null) {
			throw new AccountingManagerServiceException(
					"Error accounting type is null");
		}

		logger.debug("StartCalendar: "
				+ seriesRequest.getAccountingPeriod().getStartDate());
		logger.debug("EndCalendar: "
				+ seriesRequest.getAccountingPeriod().getEndDate());

		switch (accountingType) {
		case JOB:
			return new AccountingQuery4Job(seriesRequest);
		case PORTLET:
			return new AccountingQuery4Portlet(seriesRequest);
		case SERVICE:
			return new AccountingQuery4Service(seriesRequest);
		case STORAGE:
			return new AccountingQuery4Storage(seriesRequest);
		case TASK:
			return new AccountingQuery4Task(seriesRequest);
		default:
			throw new AccountingManagerServiceException(
					"Error request type is unknow!");

		}
	}

	private SeriesResponseBuilder getSeriesResponseBuilder(
			AccountingType accountingType, List<Info> infos)
			throws AccountingManagerServiceException {
		if (accountingType == null) {
			throw new AccountingManagerServiceException(
					"Error accounting type is null");
		}

		switch (accountingType) {
		case JOB:
			return new SeriesResponse4Job(infos);
		case PORTLET:
			return new SeriesResponse4Portlet(infos);
		case SERVICE:
			return new SeriesResponse4Service(infos);
		case STORAGE:
			return new SeriesResponse4Storage(infos);
		case TASK:
			return new SeriesResponse4Task(infos);
		default:
			throw new AccountingManagerServiceException(
					"Error request type is unknow!");

		}
	}

}
