/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.client.graphics;

public class Vector2D {
    public static Vector2D Vector2DNull = new Vector2D(0.0, 0.0);
    protected double x;
    protected double y;

    public Vector2D() {
        this.y = 0.0;
        this.x = 0.0;
    }

    public Vector2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public Vector2D add(Vector2D v) {
        Vector2D v1 = new Vector2D(this.x + v.x, this.y + v.y);
        return v1;
    }

    public Vector2D add(double s) {
        Vector2D v1 = new Vector2D(this.x + s, this.y + s);
        return v1;
    }

    public Vector2D sub(Vector2D v) {
        Vector2D v1 = new Vector2D(this.x - v.x, this.y - v.y);
        return v1;
    }

    public Vector2D sub(double s) {
        Vector2D v2 = new Vector2D(this.x - s, this.y - s);
        return v2;
    }

    public Vector2D scale(double scaleFactor) {
        Vector2D v2 = new Vector2D(this.x * scaleFactor, this.y * scaleFactor);
        return v2;
    }

    public Vector2D normalize() {
        Vector2D v2 = new Vector2D();
        double length = Math.sqrt(this.x * this.x + this.y * this.y);
        if (length != 0.0) {
            v2.x = this.x / length;
            v2.y = this.y / length;
        }
        return v2;
    }

    public double dot(Vector2D v) {
        return this.x * v.x + this.y * v.y;
    }

    public Vector2D multiply(Vector2D v) {
        Vector2D v1 = new Vector2D(this.x * v.getX(), this.y * v.getY());
        return v1;
    }

    public Vector2D multiply(double s) {
        Vector2D v1 = new Vector2D(this.x * s, this.y * s);
        return v1;
    }

    public Vector2D divide(Vector2D v) {
        Vector2D v1 = new Vector2D(this.x / v.getX(), this.y / v.getY());
        return v1;
    }

    public Vector2D divide(double s) {
        if (s != 0.0) {
            Vector2D v1 = new Vector2D(this.x / s, this.y / s);
            return v1;
        }
        return Vector2DNull;
    }

    public double distanceToSquared(Vector2D v) {
        double dx = this.x - v.x;
        double dy = this.y - v.y;
        return dx * dx + dy * dy;
    }

    public double distance(Vector2D v) {
        return Math.sqrt(this.distanceToSquared(v));
    }

    public Vector2D negate() {
        Vector2D v1 = new Vector2D(-this.x, -this.y);
        return v1;
    }

    public boolean equals(Vector2D v) {
        return v.getX() == this.x && v.getY() == this.y;
    }

    public Vector2D copy() {
        return new Vector2D(this.x, this.y);
    }

    public Vector2D floor() {
        Vector2D v1 = new Vector2D(Math.floor(this.x), Math.floor(this.y));
        return v1;
    }

    public Vector2D ceil() {
        Vector2D v1 = new Vector2D(Math.ceil(this.x), Math.ceil(this.y));
        return v1;
    }

    public Vector2D round() {
        Vector2D v1 = new Vector2D((double)Math.round(this.x), (double)Math.round(this.y));
        return v1;
    }

    public Vector2D roundToZero() {
        double dx = this.x < 0.0 ? Math.ceil(this.x) : Math.floor(this.x);
        double dy = this.y < 0.0 ? Math.ceil(this.y) : Math.floor(this.y);
        Vector2D v1 = new Vector2D(dx, dy);
        return v1;
    }

    public String toString() {
        return "Vector2D [x=" + this.x + ", y=" + this.y + "]";
    }
}

