/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.client.filters;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.cell.core.client.ButtonCell;
import com.sencha.gxt.cell.core.client.form.ComboBoxCell;
import com.sencha.gxt.core.client.IdentityValueProvider;
import com.sencha.gxt.core.client.Style;
import com.sencha.gxt.core.client.ValueProvider;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.data.shared.LabelProvider;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.data.shared.ModelKeyProvider;
import com.sencha.gxt.dnd.core.client.DND;
import com.sencha.gxt.dnd.core.client.DndDragStartEvent;
import com.sencha.gxt.dnd.core.client.GridDragSource;
import com.sencha.gxt.dnd.core.client.GridDropTarget;
import com.sencha.gxt.widget.core.client.button.ButtonBar;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.MarginData;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.event.BeforeStartEditEvent;
import com.sencha.gxt.widget.core.client.event.CancelEditEvent;
import com.sencha.gxt.widget.core.client.event.CompleteEditEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.form.ComboBox;
import com.sencha.gxt.widget.core.client.form.FieldLabel;
import com.sencha.gxt.widget.core.client.form.FieldSet;
import com.sencha.gxt.widget.core.client.form.IntegerSpinnerField;
import com.sencha.gxt.widget.core.client.form.IsField;
import com.sencha.gxt.widget.core.client.form.StringComboBox;
import com.sencha.gxt.widget.core.client.form.Validator;
import com.sencha.gxt.widget.core.client.form.validator.EmptyValidator;
import com.sencha.gxt.widget.core.client.form.validator.MaxNumberValidator;
import com.sencha.gxt.widget.core.client.form.validator.MinNumberValidator;
import com.sencha.gxt.widget.core.client.grid.CheckBoxSelectionModel;
import com.sencha.gxt.widget.core.client.grid.ColumnConfig;
import com.sencha.gxt.widget.core.client.grid.ColumnModel;
import com.sencha.gxt.widget.core.client.grid.Grid;
import com.sencha.gxt.widget.core.client.grid.GridSelectionModel;
import com.sencha.gxt.widget.core.client.grid.editing.GridRowEditing;
import com.sencha.gxt.widget.core.client.grid.filters.Filter;
import com.sencha.gxt.widget.core.client.grid.filters.GridFilters;
import com.sencha.gxt.widget.core.client.grid.filters.StringFilter;
import com.sencha.gxt.widget.core.client.toolbar.ToolBar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gcube.portlets.admin.accountingmanager.client.event.AccountingPeriodEvent;
import org.gcube.portlets.admin.accountingmanager.client.event.AccountingPeriodRequestEvent;
import org.gcube.portlets.admin.accountingmanager.client.event.StateChangeEvent;
import org.gcube.portlets.admin.accountingmanager.client.filters.ActiveFiltersPanel;
import org.gcube.portlets.admin.accountingmanager.client.monitor.AccountingMonitor;
import org.gcube.portlets.admin.accountingmanager.client.properties.AccountingFilterProperties;
import org.gcube.portlets.admin.accountingmanager.client.properties.ContextDataProperties;
import org.gcube.portlets.admin.accountingmanager.client.resource.AccountingManagerResources;
import org.gcube.portlets.admin.accountingmanager.client.rpc.AccountingManagerServiceAsync;
import org.gcube.portlets.admin.accountingmanager.client.state.AccountingClientStateData;
import org.gcube.portlets.admin.accountingmanager.client.util.UtilsGXT3;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingFilter;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingFilterBasic;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingFilterDefinition;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingFilterTop;
import org.gcube.portlets.admin.accountingmanager.shared.data.ChartType;
import org.gcube.portlets.admin.accountingmanager.shared.data.Context;
import org.gcube.portlets.admin.accountingmanager.shared.data.ContextData;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterKey;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterValuesRequest;
import org.gcube.portlets.admin.accountingmanager.shared.exception.NoScopeSelectedException;

public class ActiveFiltersPanel
extends SimpleContainer {
    private static final String CONTEXT = "Context";
    private EventBus eventBus;
    private Grid<AccountingFilter> gridFilter;
    private ListStore<AccountingFilter> storeFilter;
    private Grid<ContextData> gridScopes;
    private ListStore<ContextData> storeScopes;
    private CheckBoxSelectionModel<ContextData> smScopes;
    private ColumnConfig<ContextData, String> labelScopesCol;
    private StringFilter<ContextData> scopeFilter;
    private boolean addStatus;
    private AccountingClientStateData accountingStateData;
    private ListStore<FilterKey> storeComboFilterKey;
    private ComboBox<FilterKey> comboFilterKey;
    private ListStore<String> storeComboFilterValue;
    private StringComboBox comboFilterValue;
    private GridRowEditing<AccountingFilter> editing;
    private TextButton addButton;
    private int seq;
    private FieldLabel comboChartTypeLabel;
    private ListStore<ChartType> storeComboChartType;
    private ComboBox<ChartType> comboChartType;
    private ListStore<FilterKey> storeComboTopFilterKey;
    private ComboBox<FilterKey> comboTopFilterKey;
    private FieldLabel comboTopFilterKeyLabel;
    private ToolBar toolBar;
    private IntegerSpinnerField topNumber;
    private FieldLabel topNumberLabel;
    private FilterKey filterKey;
    private boolean cancelValue;
    private AccountingMonitor accountingMonitor;

    public ActiveFiltersPanel(EventBus eventBus) {
        Log.debug((String)"ActiveFiltersPanel");
        this.eventBus = eventBus;
        this.init();
        this.create();
        this.bindToEvents();
    }

    private void init() {
    }

    private void create() {
        AccountingFilterProperties props = (AccountingFilterProperties)GWT.create(AccountingFilterProperties.class);
        ColumnConfig keyColumn = new ColumnConfig(props.filterKey(), 130, "Key");
        keyColumn.setMenuDisabled(true);
        keyColumn.setCell((Cell)new /* Unavailable Anonymous Inner Class!! */);
        ColumnConfig valueColumn = new ColumnConfig(props.filterValue(), 130, "Value");
        valueColumn.setMenuDisabled(true);
        valueColumn.setCell((Cell)new /* Unavailable Anonymous Inner Class!! */);
        ArrayList<ColumnConfig> l = new ArrayList<ColumnConfig>();
        l.add(keyColumn);
        l.add(valueColumn);
        ColumnModel columns = new ColumnModel(l);
        this.storeFilter = new ListStore(props.id());
        GridSelectionModel sm = new GridSelectionModel();
        sm.setSelectionMode(Style.SelectionMode.SINGLE);
        this.gridFilter = new Grid(this.storeFilter, columns);
        this.gridFilter.setSelectionModel(sm);
        this.gridFilter.getView().setStripeRows(true);
        this.gridFilter.getView().setColumnLines(true);
        this.gridFilter.getView().setAutoFill(true);
        this.gridFilter.setBorders(true);
        this.gridFilter.setColumnReordering(false);
        this.gridFilter.getView().setAutoExpandColumn(valueColumn);
        this.gridFilter.getView().setSortingEnabled(false);
        GridDragSource ds = new GridDragSource(this.gridFilter);
        ds.addDragStartHandler((DndDragStartEvent.DndDragStartHandler)new /* Unavailable Anonymous Inner Class!! */);
        GridDropTarget dt = new GridDropTarget(this.gridFilter);
        dt.setFeedback(DND.Feedback.BOTH);
        dt.setAllowSelfAsSource(true);
        FilterKeyPropertiesCombo filterKeyPropertiesCombo = (FilterKeyPropertiesCombo)GWT.create(FilterKeyPropertiesCombo.class);
        this.storeComboFilterKey = new ListStore(filterKeyPropertiesCombo.id());
        this.comboFilterKey = new ComboBox(this.storeComboFilterKey, filterKeyPropertiesCombo.key());
        this.comboFilterKey.setClearValueOnParseError(false);
        this.comboFilterKey.setEditable(false);
        this.comboFilterKey.addValidator((Validator)new /* Unavailable Anonymous Inner Class!! */);
        this.comboFilterKey.setTriggerAction(ComboBoxCell.TriggerAction.ALL);
        this.addHandlersForComboFilterKey(filterKeyPropertiesCombo.key());
        this.storeComboFilterValue = new ListStore((ModelKeyProvider)new /* Unavailable Anonymous Inner Class!! */);
        this.comboFilterValue = new StringComboBox();
        this.comboFilterValue.setStore(this.storeComboFilterValue);
        this.comboFilterValue.setClearValueOnParseError(false);
        this.comboFilterValue.setEditable(true);
        this.comboFilterValue.setForceSelection(false);
        this.comboFilterValue.addValidator((Validator)new EmptyValidator());
        this.comboFilterValue.setTriggerAction(ComboBoxCell.TriggerAction.ALL);
        this.editing = new GridRowEditing(this.gridFilter);
        this.editing.addEditor(keyColumn, (IsField)this.comboFilterKey);
        this.editing.addEditor(valueColumn, (IsField)this.comboFilterValue);
        this.addButton = new TextButton("Add Filter");
        this.addButton.setIcon(AccountingManagerResources.INSTANCE.accountingFilter24());
        this.addButton.setIconAlign(ButtonCell.IconAlign.RIGHT);
        this.addButton.setToolTip("Add Filter");
        this.addButton.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        TextButton deleteBtn = new TextButton("Delete");
        deleteBtn.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        ButtonBar buttonBar = this.editing.getButtonBar();
        buttonBar.add((Widget)deleteBtn);
        this.editing.addBeforeStartEditHandler((BeforeStartEditEvent.BeforeStartEditHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.editing.addCancelEditHandler((CancelEditEvent.CancelEditHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.editing.addCompleteEditHandler((CompleteEditEvent.CompleteEditHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.toolBar = new ToolBar();
        this.toolBar.add((IsWidget)this.addButton, new BoxLayoutContainer.BoxLayoutData(new Margins(0)));
        ContextDataProperties propsScopeData = (ContextDataProperties)GWT.create(ContextDataProperties.class);
        IdentityValueProvider identity = new IdentityValueProvider();
        this.smScopes = new CheckBoxSelectionModel((ValueProvider)identity);
        this.labelScopesCol = new ColumnConfig(propsScopeData.label(), 356, CONTEXT);
        this.labelScopesCol.setCell((Cell)new /* Unavailable Anonymous Inner Class!! */);
        ArrayList<ColumnConfig> lcolumnsScopes = new ArrayList<ColumnConfig>();
        lcolumnsScopes.add(this.smScopes.getColumn());
        lcolumnsScopes.add(this.labelScopesCol);
        ColumnModel cmContextData = new ColumnModel(lcolumnsScopes);
        this.storeScopes = new ListStore(propsScopeData.id());
        this.gridScopes = new Grid(this.storeScopes, cmContextData);
        sm.setSelectionMode(Style.SelectionMode.MULTI);
        this.gridScopes.setHeight("130px");
        this.gridScopes.setSelectionModel((GridSelectionModel)this.smScopes);
        this.gridScopes.getView().setStripeRows(true);
        this.gridScopes.getView().setColumnLines(true);
        this.gridScopes.getView().setAutoFill(true);
        this.gridScopes.setBorders(true);
        this.gridScopes.setColumnReordering(false);
        this.gridScopes.getView().setAutoExpandColumn(this.labelScopesCol);
        this.gridScopes.getView().setSortingEnabled(true);
        this.scopeFilter = new StringFilter(propsScopeData.label());
        GridFilters gridScopesFilters = new GridFilters();
        gridScopesFilters.initPlugin(this.gridScopes);
        gridScopesFilters.setLocal(true);
        gridScopesFilters.addFilter((Filter)this.scopeFilter);
        this.storeComboChartType = new ListStore((ModelKeyProvider)new /* Unavailable Anonymous Inner Class!! */);
        13 comboChartTypeLabelProvider = new /* Unavailable Anonymous Inner Class!! */;
        this.comboChartType = new ComboBox(this.storeComboChartType, (LabelProvider)comboChartTypeLabelProvider);
        this.comboChartType.setClearValueOnParseError(false);
        this.comboChartType.setEditable(false);
        this.comboChartType.setForceSelection(true);
        this.comboChartType.setValue((Object)ChartType.Basic);
        this.comboChartType.setTriggerAction(ComboBoxCell.TriggerAction.ALL);
        this.addHandlersForComboChartType((LabelProvider)comboChartTypeLabelProvider);
        this.comboChartTypeLabel = new FieldLabel((IsWidget)this.comboChartType, "Chart");
        this.storeComboTopFilterKey = new ListStore(filterKeyPropertiesCombo.id());
        this.comboTopFilterKey = new ComboBox(this.storeComboTopFilterKey, filterKeyPropertiesCombo.key());
        this.comboTopFilterKey.setClearValueOnParseError(false);
        this.comboTopFilterKey.setEditable(false);
        this.comboTopFilterKey.setTriggerAction(ComboBoxCell.TriggerAction.ALL);
        this.addHandlersForComboTopFilterKey(filterKeyPropertiesCombo.key());
        this.comboTopFilterKeyLabel = new FieldLabel((IsWidget)this.comboTopFilterKey, "Key");
        this.topNumber = new IntegerSpinnerField();
        this.topNumber.setMaxValue((Number)100);
        this.topNumber.setMinValue((Number)1);
        this.topNumber.setAllowNegative(false);
        this.topNumber.setAllowBlank(false);
        this.topNumber.setValue((Object)10);
        this.topNumber.setEditable(true);
        this.topNumber.addValidator((Validator)new MinNumberValidator((Number)1));
        this.topNumber.addValidator((Validator)new MaxNumberValidator((Number)100));
        this.topNumberLabel = new FieldLabel((IsWidget)this.topNumber, "Number");
        VerticalLayoutContainer vlc = new VerticalLayoutContainer();
        vlc.add((IsWidget)this.gridScopes, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        vlc.add((IsWidget)this.comboChartTypeLabel, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(10, 0, 0, 0)));
        vlc.add((IsWidget)this.comboTopFilterKeyLabel, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        vlc.add((IsWidget)this.topNumberLabel, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        vlc.add((IsWidget)this.toolBar, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        vlc.add((IsWidget)this.gridFilter, new VerticalLayoutContainer.VerticalLayoutData(1.0, 1.0, new Margins(0)));
        FieldSet fieldSet = new FieldSet();
        fieldSet.setHeight("450px");
        fieldSet.setHeadingHtml("<b>Active Filters</b>");
        fieldSet.setCollapsible(false);
        fieldSet.add((Widget)vlc);
        this.add((Widget)fieldSet, new MarginData(0));
        this.gridScopes.setVisible(false);
        this.comboChartTypeLabel.setVisible(false);
        this.comboTopFilterKeyLabel.setVisible(false);
        this.topNumberLabel.setVisible(false);
    }

    private void bindToEvents() {
        this.eventBus.addHandler(StateChangeEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.eventBus.addHandler(AccountingPeriodEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void doStateChangeCommand(StateChangeEvent event) {
        if (event.getStateChangeType() == null) {
            return;
        }
        switch (20.$SwitchMap$org$gcube$portlets$admin$accountingmanager$client$type$StateChangeType[event.getStateChangeType().ordinal()]) {
            case 1: {
                this.onRestoreStateChange(event);
                break;
            }
            case 2: {
                break;
            }
        }
    }

    private void onRestoreStateChange(StateChangeEvent event) {
        Log.debug((String)("onRestoreStateChange: " + event));
        if (event.getAccountingStateData() != null) {
            this.accountingStateData = event.getAccountingStateData();
            if (this.accountingStateData.getAccountingType() != null) {
                switch (20.$SwitchMap$org$gcube$portlets$admin$accountingmanager$shared$data$AccountingType[this.accountingStateData.getAccountingType().ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        ArrayList chartsTypeForDefault = new ArrayList(ChartType.asList());
                        Log.debug((String)("ChartsType: " + chartsTypeForDefault));
                        chartsTypeForDefault.remove(ChartType.Spaces);
                        Log.debug((String)("ChartsType after remove: " + chartsTypeForDefault));
                        this.storeComboChartType.clear();
                        this.storeComboChartType.addAll(chartsTypeForDefault);
                        this.storeComboChartType.commitChanges();
                        this.comboChartTypeLabel.setVisible(true);
                        break;
                    }
                    case 6: {
                        ArrayList<ChartType> chartsTypeForSpace = new ArrayList<ChartType>();
                        chartsTypeForSpace.add(ChartType.Spaces);
                        Log.debug((String)("ChartsType: " + chartsTypeForSpace));
                        this.storeComboChartType.clear();
                        this.storeComboChartType.addAll(chartsTypeForSpace);
                        this.storeComboChartType.commitChanges();
                        this.comboChartTypeLabel.setVisible(false);
                        break;
                    }
                    default: {
                        this.storeComboChartType.clear();
                        this.storeComboChartType.commitChanges();
                        this.comboChartTypeLabel.setVisible(false);
                        break;
                    }
                }
            } else {
                this.storeComboChartType.clear();
                this.storeComboChartType.commitChanges();
                this.comboChartTypeLabel.setVisible(false);
            }
            this.changeActiveFilters();
        } else {
            this.accountingStateData = null;
            this.seq = 0;
        }
        Log.debug((String)("Set seq to: " + this.seq));
        this.forceLayout();
    }

    private void changeActiveFilters() {
        this.storeComboFilterKey.clear();
        this.storeComboFilterKey.addAll((Collection)this.accountingStateData.getAvailableFilterKeys());
        this.storeComboFilterKey.commitChanges();
        this.storeComboTopFilterKey.clear();
        this.storeComboTopFilterKey.addAll((Collection)this.accountingStateData.getAvailableFilterKeys());
        this.storeComboTopFilterKey.commitChanges();
        ChartType chartType = this.accountingStateData.getSeriesRequest().getAccountingFilterDefinition().getChartType();
        switch (20.$SwitchMap$org$gcube$portlets$admin$accountingmanager$shared$data$ChartType[chartType.ordinal()]) {
            case 1: {
                this.changeActiveFiltersForBasic();
                break;
            }
            case 2: {
                this.changeActiveFiltersForTop();
                break;
            }
            case 3: {
                break;
            }
            default: {
                this.changeActiveFiltersForBasic();
            }
        }
    }

    private void changeActiveFiltersForBasic() {
        Log.debug((String)"ChangeActiveFiltersForBasic");
        if (this.accountingStateData.getSeriesRequest() != null && this.accountingStateData.getSeriesRequest().getAccountingFilterDefinition() != null && this.accountingStateData.getSeriesRequest().getAccountingFilterDefinition() instanceof AccountingFilterBasic) {
            AccountingFilterBasic accountingFilterBasic = (AccountingFilterBasic)this.accountingStateData.getSeriesRequest().getAccountingFilterDefinition();
            if (this.accountingStateData.getAvailableContext() != null && this.accountingStateData.getAvailableContext().getContexts() != null && !this.accountingStateData.getAvailableContext().getContexts().isEmpty()) {
                if (accountingFilterBasic.getContext() != null && accountingFilterBasic.getContext().getContexts() != null && !accountingFilterBasic.getContext().getContexts().isEmpty()) {
                    ArrayList contexts = this.accountingStateData.getAvailableContext().getContexts();
                    ArrayList<ContextData> scopes = new ArrayList<ContextData>();
                    for (String context : contexts) {
                        ContextData contextData = new ContextData(context);
                        scopes.add(contextData);
                    }
                    this.storeScopes.clear();
                    this.storeScopes.setEnableFilters(false);
                    this.storeScopes.addAll(scopes);
                    this.storeScopes.commitChanges();
                    Log.debug((String)("ScopeFilterActive: " + accountingFilterBasic.getScopeFilterActive()));
                    if (accountingFilterBasic.getScopeFilterActive() != null && !accountingFilterBasic.getScopeFilterActive().isEmpty()) {
                        this.scopeFilter.setValue(accountingFilterBasic.getScopeFilterActive());
                        this.scopeFilter.setActive(true, false);
                        this.storeScopes.setEnableFilters(true);
                        this.storeScopes.commitChanges();
                    } else {
                        this.scopeFilter.setValue(null);
                        this.scopeFilter.setActive(false, false);
                    }
                    this.smScopes.deselectAll();
                    if (accountingFilterBasic.getContext().getContexts() != null && !accountingFilterBasic.getContext().getContexts().isEmpty()) {
                        ArrayList<ContextData> selected = new ArrayList<ContextData>();
                        block1: for (String c : accountingFilterBasic.getContext().getContexts()) {
                            for (ContextData contextData : this.storeScopes.getAll()) {
                                if (c.compareTo(contextData.getContextData()) != 0) continue;
                                selected.add(contextData);
                                continue block1;
                            }
                        }
                        if (!selected.isEmpty()) {
                            if (selected.size() == this.storeScopes.getAll().size()) {
                                Log.debug((String)"Select All Scope");
                                this.smScopes.selectAll();
                            } else {
                                Log.debug((String)("Select Scope: " + selected));
                                this.smScopes.select(selected, false);
                            }
                        }
                    }
                    this.smScopes.refresh();
                } else {
                    this.repopulatesContexts();
                }
            } else {
                this.resetContexts();
            }
            if (accountingFilterBasic.getFilters() != null) {
                ArrayList filters = accountingFilterBasic.getFilters();
                this.storeFilter.clear();
                this.storeFilter.addAll((Collection)filters);
                this.seq = 0;
                for (AccountingFilter filter : filters) {
                    if (filter.getId() <= this.seq) continue;
                    this.seq = filter.getId();
                }
                this.storeFilter.commitChanges();
            } else {
                this.storeFilter.clear();
                this.storeFilter.commitChanges();
                this.seq = 0;
            }
        } else {
            this.reconfigureContext();
            this.storeFilter.clear();
            this.storeFilter.commitChanges();
            this.seq = 0;
        }
        this.gridScopes.setVisible(true);
        this.labelScopesCol.setHeader(CONTEXT);
        this.gridScopes.getView().refresh(true);
        this.comboChartType.setValue((Object)ChartType.Basic);
        this.comboTopFilterKey.reset();
        this.comboTopFilterKeyLabel.setVisible(false);
        this.topNumber.reset();
        this.topNumberLabel.setVisible(false);
        this.forceLayout();
    }

    private void changeActiveFiltersForTop() {
        Log.debug((String)"ChangeActiveFiltersForTop");
        if (this.accountingStateData.getSeriesRequest() != null && this.accountingStateData.getSeriesRequest().getAccountingFilterDefinition() != null && this.accountingStateData.getSeriesRequest().getAccountingFilterDefinition() instanceof AccountingFilterTop) {
            AccountingFilterTop accountingFilterTop = (AccountingFilterTop)this.accountingStateData.getSeriesRequest().getAccountingFilterDefinition();
            if (this.accountingStateData.getAvailableContext() != null && this.accountingStateData.getAvailableContext().getContexts() != null && !this.accountingStateData.getAvailableContext().getContexts().isEmpty()) {
                if (accountingFilterTop.getContext() != null && accountingFilterTop.getContext().getContexts() != null && !accountingFilterTop.getContext().getContexts().isEmpty()) {
                    ArrayList contexts = this.accountingStateData.getAvailableContext().getContexts();
                    ArrayList<ContextData> scopes = new ArrayList<ContextData>();
                    for (String context : contexts) {
                        ContextData contextData = new ContextData(context);
                        scopes.add(contextData);
                    }
                    this.storeScopes.clear();
                    this.storeScopes.setEnableFilters(false);
                    this.storeScopes.addAll(scopes);
                    this.storeScopes.commitChanges();
                    Log.debug((String)("ScopeFilterActive: " + accountingFilterTop.getScopeFilterActive()));
                    if (accountingFilterTop.getScopeFilterActive() != null && !accountingFilterTop.getScopeFilterActive().isEmpty()) {
                        this.scopeFilter.setValue(accountingFilterTop.getScopeFilterActive());
                        this.scopeFilter.setActive(true, false);
                        this.storeScopes.setEnableFilters(true);
                        this.storeScopes.commitChanges();
                    } else {
                        this.scopeFilter.setValue(null);
                        this.scopeFilter.setActive(false, false);
                    }
                    this.smScopes.deselectAll();
                    if (accountingFilterTop.getContext().getContexts() != null && !accountingFilterTop.getContext().getContexts().isEmpty()) {
                        ArrayList<ContextData> selected = new ArrayList<ContextData>();
                        block1: for (String c : accountingFilterTop.getContext().getContexts()) {
                            for (ContextData contextData : this.storeScopes.getAll()) {
                                if (c.compareTo(contextData.getContextData()) != 0) continue;
                                selected.add(contextData);
                                continue block1;
                            }
                        }
                        if (!selected.isEmpty()) {
                            if (selected.size() == this.storeScopes.getAll().size()) {
                                Log.debug((String)"Select All Scope");
                                this.smScopes.selectAll();
                            } else {
                                Log.debug((String)("Select Scope: " + selected));
                                this.smScopes.select(selected, false);
                            }
                        }
                    }
                    this.smScopes.refresh();
                } else {
                    this.repopulatesContexts();
                }
            } else {
                this.resetContexts();
            }
            if (accountingFilterTop.getFilterKey() != null) {
                this.comboTopFilterKey.setValue((Object)accountingFilterTop.getFilterKey());
                this.topNumber.setValue((Object)accountingFilterTop.getTopNumber());
                if (accountingFilterTop.getFilters() != null) {
                    ArrayList filters = accountingFilterTop.getFilters();
                    this.storeFilter.clear();
                    this.storeFilter.addAll((Collection)filters);
                    this.seq = 0;
                    for (AccountingFilter filter : filters) {
                        if (filter.getId() <= this.seq) continue;
                        this.seq = filter.getId();
                    }
                    this.storeFilter.commitChanges();
                } else {
                    this.storeFilter.clear();
                    this.storeFilter.commitChanges();
                    this.seq = 0;
                }
            } else {
                this.comboTopFilterKey.reset();
                this.topNumber.reset();
                this.topNumber.setValue((Object)10);
                this.storeFilter.clear();
                this.storeFilter.commitChanges();
                this.seq = 0;
            }
        } else {
            if (this.accountingStateData.getAvailableContext().getContexts() != null && !this.accountingStateData.getAvailableContext().getContexts().isEmpty()) {
                ArrayList contexts = this.accountingStateData.getAvailableContext().getContexts();
                ArrayList<ContextData> scopes = new ArrayList<ContextData>();
                for (String context : contexts) {
                    scopes.add(new ContextData(context));
                }
                this.storeScopes.clear();
                this.storeScopes.setEnableFilters(false);
                this.storeScopes.addAll(scopes);
                this.storeScopes.commitChanges();
            } else {
                this.storeScopes.clear();
                this.storeScopes.setEnableFilters(false);
                this.storeScopes.commitChanges();
            }
            this.scopeFilter.setValue(null);
            this.scopeFilter.setActive(false, false);
            this.smScopes.deselectAll();
            this.comboTopFilterKey.reset();
            this.topNumber.reset();
            this.topNumber.setValue((Object)10);
            this.storeFilter.clear();
            this.storeFilter.commitChanges();
            this.seq = 0;
        }
        this.gridScopes.setVisible(true);
        this.labelScopesCol.setHeader(CONTEXT);
        this.gridScopes.getView().refresh(true);
        this.comboChartType.setValue((Object)ChartType.Top);
        this.comboTopFilterKeyLabel.setVisible(true);
        this.topNumberLabel.setVisible(true);
        this.forceLayout();
    }

    private void reconfigureContext() {
        if (this.accountingStateData.getAvailableContext() != null && this.accountingStateData.getAvailableContext().getContexts() != null && !this.accountingStateData.getAvailableContext().getContexts().isEmpty()) {
            this.repopulatesContexts();
        } else {
            this.resetContexts();
        }
    }

    private void resetContexts() {
        this.storeScopes.clear();
        this.storeScopes.commitChanges();
        this.scopeFilter.setValue(null);
        this.scopeFilter.setActive(false, false);
        this.smScopes.deselectAll();
        this.smScopes.refresh();
    }

    private void repopulatesContexts() {
        ArrayList contexts = this.accountingStateData.getAvailableContext().getContexts();
        ArrayList<ContextData> contextList = new ArrayList<ContextData>();
        for (String context : contexts) {
            ContextData contextData = new ContextData(context);
            contextList.add(contextData);
        }
        this.storeScopes.clear();
        this.storeScopes.addAll(contextList);
        this.storeScopes.commitChanges();
        this.scopeFilter.setValue(null);
        this.scopeFilter.setActive(false, false);
        this.smScopes.selectAll();
        this.smScopes.refresh();
    }

    public AccountingFilterDefinition getActiveFilters() {
        try {
            ChartType chartType = (ChartType)this.comboChartType.getCurrentValue();
            switch (20.$SwitchMap$org$gcube$portlets$admin$accountingmanager$shared$data$ChartType[chartType.ordinal()]) {
                case 1: {
                    return this.getActiveFiltersForBasic();
                }
                case 2: {
                    return this.getActiveFiltersForTop();
                }
            }
            return null;
        }
        catch (NoScopeSelectedException e) {
            UtilsGXT3.alert((String)"Attention", (String)e.getLocalizedMessage());
            return null;
        }
        catch (Throwable e) {
            Log.error((String)e.getLocalizedMessage());
            e.printStackTrace();
            UtilsGXT3.alert((String)"Attention", (String)e.getLocalizedMessage());
            return null;
        }
    }

    private AccountingFilterDefinition getActiveFiltersForBasic() throws NoScopeSelectedException {
        ArrayList<String> contextsSelected = new ArrayList<String>();
        if (this.storeScopes != null && this.storeScopes.size() > 0 && this.smScopes != null) {
            List selected = this.smScopes.getSelectedItems();
            for (ContextData cd : selected) {
                contextsSelected.add(cd.getContextData());
            }
        }
        if (contextsSelected.isEmpty()) {
            String msg = "No Scope selected! Please, select a Scope.";
            Log.info((String)msg);
            throw new NoScopeSelectedException(msg);
        }
        Context context = new Context(contextsSelected);
        Log.debug((String)("Context selected: " + context));
        String scopeFilterActive = null;
        if (this.scopeFilter.isActive()) {
            scopeFilterActive = (String)this.scopeFilter.getValue();
        }
        Log.debug((String)("Scope Filter Active: " + scopeFilterActive));
        if (this.storeFilter == null || this.storeFilter.size() <= 0) {
            return new AccountingFilterBasic(context, scopeFilterActive);
        }
        List filtersActives = this.storeFilter.getAll();
        ArrayList<AccountingFilter> filtersReady = new ArrayList<AccountingFilter>();
        for (AccountingFilter filter : filtersActives) {
            if (filter.getFilterValue() == null || filter.getFilterValue().isEmpty()) continue;
            filtersReady.add(filter);
        }
        if (filtersReady.size() > 0) {
            return new AccountingFilterBasic(context, scopeFilterActive, filtersReady);
        }
        return new AccountingFilterBasic(context, scopeFilterActive);
    }

    private AccountingFilterDefinition getActiveFiltersForTop() throws NoScopeSelectedException {
        ArrayList<String> contextsSelected = new ArrayList<String>();
        if (this.storeScopes != null && this.storeScopes.size() > 0 && this.smScopes != null) {
            List selected = this.smScopes.getSelectedItems();
            for (ContextData cd : selected) {
                contextsSelected.add(cd.getContextData());
            }
        }
        if (contextsSelected.isEmpty()) {
            String msg = "No Scope selected! Please, select a Scope.";
            Log.info((String)msg);
            throw new NoScopeSelectedException(msg);
        }
        Context context = new Context(contextsSelected);
        Log.debug((String)("Context selected: " + context));
        String scopeFilterActive = null;
        if (this.scopeFilter.isActive()) {
            scopeFilterActive = (String)this.scopeFilter.getValue();
        }
        Log.debug((String)("Scope Filter Active: " + scopeFilterActive));
        Integer topN = (Integer)this.topNumber.getCurrentValue();
        if (topN != null) {
            if (topN < 1) {
                topN = 1;
                this.topNumber.setValue((Object)topN, true, true);
                this.topNumber.clearInvalid();
            } else if (topN > 100) {
                topN = 100;
                this.topNumber.setValue((Object)topN, true, true);
                this.topNumber.clearInvalid();
            }
        } else {
            topN = 10;
            this.topNumber.setValue((Object)topN, true, true);
            this.topNumber.clearInvalid();
        }
        FilterKey filterKey = (FilterKey)this.comboTopFilterKey.getCurrentValue();
        if (filterKey == null) {
            return new AccountingFilterTop(context, scopeFilterActive, topN);
        }
        if (this.storeFilter == null || this.storeFilter.size() <= 0) {
            return new AccountingFilterTop(context, scopeFilterActive, filterKey, null, topN);
        }
        List filtersActives = this.storeFilter.getAll();
        ArrayList<AccountingFilter> filtersReady = new ArrayList<AccountingFilter>();
        for (AccountingFilter filter : filtersActives) {
            if (filter.getFilterValue() == null || filter.getFilterValue().isEmpty()) continue;
            filtersReady.add(filter);
        }
        if (filtersReady.size() > 0) {
            return new AccountingFilterTop(context, scopeFilterActive, filterKey, filtersReady, topN);
        }
        return new AccountingFilterTop(context, scopeFilterActive, filterKey, null, topN);
    }

    private void addNewFilter(SelectEvent event) {
        FilterKey fk = null;
        if (this.accountingStateData == null || this.accountingStateData.getAvailableFilterKeys() == null || this.accountingStateData.getAvailableFilterKeys().size() < 0) {
            UtilsGXT3.info((String)"No key available", (String)"No key available");
        } else {
            ArrayList remainingFilterKeys = new ArrayList(this.accountingStateData.getAvailableFilterKeys());
            ArrayList<Object> removableFilterKeys = new ArrayList<Object>();
            if (this.comboChartType.getCurrentValue() != null && ((ChartType)this.comboChartType.getCurrentValue()).compareTo((Enum)ChartType.Top) == 0 && this.comboTopFilterKey.getCurrentValue() != null) {
                removableFilterKeys.add(this.comboTopFilterKey.getCurrentValue());
            }
            remainingFilterKeys.removeAll(removableFilterKeys);
            if (remainingFilterKeys.size() > 0) {
                fk = new FilterKey("");
                ++this.seq;
                AccountingFilter newAccountingFilter = new AccountingFilter(this.seq, fk, "");
                Log.debug((String)("newAccountingFilter: " + newAccountingFilter));
                this.editing.cancelEditing();
                this.addStatus = true;
                this.editing.getCancelButton().setVisible(false);
                this.storeFilter.add((Object)newAccountingFilter);
                int row = this.storeFilter.indexOf((Object)newAccountingFilter);
                this.storeComboFilterKey.clear();
                this.storeComboFilterKey.addAll(remainingFilterKeys);
                this.storeComboFilterKey.commitChanges();
                this.editing.startEditing(new Grid.GridCell(row, 0));
            } else {
                UtilsGXT3.info((String)"No key available", (String)"No key available");
            }
        }
    }

    private void retrieveFilterValuesByKey(FilterKey filterKey, boolean cancelValue) {
        this.filterKey = filterKey;
        this.cancelValue = cancelValue;
        AccountingPeriodRequestEvent event = new AccountingPeriodRequestEvent();
        this.eventBus.fireEvent((GwtEvent)event);
    }

    private void manageAccountingPeriodEvent(AccountingPeriodEvent event) {
        if (event == null || event.getAccountingPeriod() == null) {
            Log.debug((String)"AccountingPeriod not valid");
            return;
        }
        if (this.filterKey == null || this.filterKey.getKey() == null || this.filterKey.getKey().isEmpty()) {
            Log.debug((String)("FilterKey: " + this.filterKey));
            this.comboFilterValue.clear();
            this.storeComboFilterValue.clear();
            this.storeComboFilterValue.commitChanges();
            return;
        }
        this.accountingMonitor = new AccountingMonitor();
        FilterValuesRequest requestFilterValue = new FilterValuesRequest(this.filterKey, this.accountingStateData.getAccountingType(), event.getAccountingPeriod());
        AccountingManagerServiceAsync.INSTANCE.getFilterValues(requestFilterValue, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void editingBeforeStart(BeforeStartEditEvent<AccountingFilter> event) {
        Grid.GridCell cell = event.getEditCell();
        int rowIndex = cell.getRow();
        AccountingFilter editingFilter = (AccountingFilter)this.storeFilter.get(rowIndex);
        ArrayList remainingFilterKeys = null;
        remainingFilterKeys = this.accountingStateData == null || this.accountingStateData.getAvailableFilterKeys() == null ? new ArrayList() : new ArrayList(this.accountingStateData.getAvailableFilterKeys());
        ArrayList<Object> setFilterKeys = new ArrayList<Object>();
        if (this.comboChartType.getCurrentValue() != null && ((ChartType)this.comboChartType.getCurrentValue()).compareTo((Enum)ChartType.Top) == 0 && this.comboTopFilterKey.getCurrentValue() != null) {
            setFilterKeys.add(this.comboTopFilterKey.getCurrentValue());
        }
        remainingFilterKeys.removeAll(setFilterKeys);
        this.storeComboFilterKey.clear();
        this.storeComboFilterKey.addAll(remainingFilterKeys);
        this.storeComboFilterKey.commitChanges();
        if (editingFilter.getFilterKey() != null) {
            this.retrieveFilterValuesByKey(editingFilter.getFilterKey(), false);
        }
        this.addButton.setEnabled(false);
    }

    private void addHandlersForComboFilterKey(LabelProvider<FilterKey> labelProvider) {
        this.comboFilterKey.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateFilterKey(FilterKey selectedFilterKey) {
        this.retrieveFilterValuesByKey(selectedFilterKey, true);
    }

    private void addHandlersForComboChartType(LabelProvider<ChartType> labelProvider) {
        this.comboChartType.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateComboChartType(ChartType chartType) {
        if (chartType == null) {
            return;
        }
        switch (20.$SwitchMap$org$gcube$portlets$admin$accountingmanager$shared$data$ChartType[chartType.ordinal()]) {
            case 1: {
                this.comboTopFilterKey.reset();
                this.comboTopFilterKeyLabel.setVisible(false);
                this.topNumber.reset();
                this.topNumberLabel.setVisible(false);
                this.storeFilter.clear();
                this.storeFilter.commitChanges();
                this.seq = 0;
                this.forceLayout();
                break;
            }
            case 2: {
                this.comboTopFilterKey.reset();
                if (this.accountingStateData != null && this.accountingStateData.getAvailableFilterKeys() != null && this.accountingStateData.getAvailableFilterKeys().size() > 0) {
                    this.comboTopFilterKey.setValue(this.accountingStateData.getAvailableFilterKeys().get(0));
                }
                this.comboTopFilterKeyLabel.setVisible(true);
                this.topNumber.reset();
                this.topNumber.setValue((Object)10);
                this.topNumberLabel.setVisible(true);
                this.storeFilter.clear();
                this.storeFilter.commitChanges();
                this.seq = 0;
                this.forceLayout();
                break;
            }
        }
    }

    private void addHandlersForComboTopFilterKey(LabelProvider<FilterKey> labelProvider) {
        this.comboTopFilterKey.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateTopFilterKey(FilterKey selectedFilterKey) {
        this.storeFilter.clear();
        this.storeFilter.commitChanges();
        this.seq = 0;
    }

    static /* synthetic */ void access$000(ActiveFiltersPanel x0, SelectEvent x1) {
        x0.addNewFilter(x1);
    }

    static /* synthetic */ GridRowEditing access$100(ActiveFiltersPanel x0) {
        return x0.editing;
    }

    static /* synthetic */ ListStore access$200(ActiveFiltersPanel x0) {
        return x0.storeFilter;
    }

    static /* synthetic */ TextButton access$300(ActiveFiltersPanel x0) {
        return x0.addButton;
    }

    static /* synthetic */ boolean access$400(ActiveFiltersPanel x0) {
        return x0.addStatus;
    }

    static /* synthetic */ boolean access$402(ActiveFiltersPanel x0, boolean x1) {
        x0.addStatus = x1;
        return x0.addStatus;
    }

    static /* synthetic */ void access$500(ActiveFiltersPanel x0, BeforeStartEditEvent x1) {
        x0.editingBeforeStart(x1);
    }

    static /* synthetic */ void access$600(ActiveFiltersPanel x0, StateChangeEvent x1) {
        x0.doStateChangeCommand(x1);
    }

    static /* synthetic */ void access$700(ActiveFiltersPanel x0, AccountingPeriodEvent x1) {
        x0.manageAccountingPeriodEvent(x1);
    }

    static /* synthetic */ AccountingMonitor access$800(ActiveFiltersPanel x0) {
        return x0.accountingMonitor;
    }

    static /* synthetic */ EventBus access$900(ActiveFiltersPanel x0) {
        return x0.eventBus;
    }

    static /* synthetic */ boolean access$1000(ActiveFiltersPanel x0) {
        return x0.cancelValue;
    }

    static /* synthetic */ StringComboBox access$1100(ActiveFiltersPanel x0) {
        return x0.comboFilterValue;
    }

    static /* synthetic */ ListStore access$1200(ActiveFiltersPanel x0) {
        return x0.storeComboFilterValue;
    }

    static /* synthetic */ void access$1300(ActiveFiltersPanel x0, FilterKey x1) {
        x0.updateFilterKey(x1);
    }

    static /* synthetic */ void access$1400(ActiveFiltersPanel x0, ChartType x1) {
        x0.updateComboChartType(x1);
    }

    static /* synthetic */ void access$1500(ActiveFiltersPanel x0, FilterKey x1) {
        x0.updateTopFilterKey(x1);
    }
}

