/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletContextEvent;
import org.gcube.portlets.admin.accountingmanager.server.AccountingClientCallable;
import org.gcube.portlets.admin.accountingmanager.server.amservice.cache.AccountingCache;
import org.gcube.portlets.admin.accountingmanager.server.is.BuildThreadPoolInfo;
import org.gcube.portlets.admin.accountingmanager.server.util.TaskInProgress;
import org.gcube.portlets.admin.accountingmanager.server.util.TaskRequest;
import org.gcube.portlets.admin.accountingmanager.server.util.TaskStatus;
import org.gcube.portlets.admin.accountingmanager.server.util.ThreadPoolInfo;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingClientDaemon
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(AccountingClientDaemon.class);
    private long timeout = 1800000L;
    private long timeoutUpdate = 86400000L;
    private ServletContextEvent sce;
    private volatile boolean running = true;
    private volatile AccountingCache accountingCache;
    private ArrayList<TaskInProgress> tasks;
    private Timer threadPoolTimeoutUpdateTimer = null;

    public AccountingClientDaemon(ServletContextEvent sce, AccountingCache accountingCache) {
        this.sce = sce;
        this.accountingCache = accountingCache;
        this.tasks = new ArrayList();
        this.initTimeout();
    }

    private void initTimeout() {
        this.sce.getServletContext().setAttribute("ACCOUNTING_CLIENT_MONITOR_TIME_OUT_PERIODMILLIS", (Object)this.timeout);
        this.retrieveTimeOut();
        this.startThreadPoolTimeoutUpdateTimer();
    }

    public void terminate() {
        this.running = false;
        if (this.threadPoolTimeoutUpdateTimer != null) {
            this.threadPoolTimeoutUpdateTimer.cancel();
        }
    }

    @Override
    public void run() {
        ConcurrentLinkedQueue jobQueue = new ConcurrentLinkedQueue();
        this.sce.getServletContext().setAttribute("TASK_REQUEST_QUEUE", jobQueue);
        ExecutorService executorService = Executors.newFixedThreadPool(20);
        while (this.running) {
            while (!jobQueue.isEmpty()) {
                TaskRequest taskRequest = (TaskRequest)jobQueue.poll();
                AccountingClientCallable accountingClientCallable = new AccountingClientCallable(taskRequest, this.accountingCache);
                Future futureResult = executorService.submit(accountingClientCallable);
                TaskInProgress taskInProgress = new TaskInProgress((Calendar)new GregorianCalendar(), futureResult);
                this.tasks.add(taskInProgress);
            }
            if (!this.tasks.isEmpty()) {
                ArrayList<TaskInProgress> dones = new ArrayList<TaskInProgress>();
                for (TaskInProgress taskInProgress : this.tasks) {
                    Future futureResult = taskInProgress.getFuture();
                    if (futureResult.isDone()) {
                        TaskStatus result = null;
                        try {
                            result = (TaskStatus)futureResult.get(this.timeout, TimeUnit.MILLISECONDS);
                            logger.debug("AccountingClientTask: " + result);
                        }
                        catch (InterruptedException | ExecutionException e) {
                            logger.error("AccountingClientTask: " + e.getLocalizedMessage(), (Throwable)e);
                        }
                        catch (TimeoutException e) {
                            logger.error("AccountingClientTask No response after " + this.timeout + " milliseconds!");
                            futureResult.cancel(true);
                        }
                        dones.add(taskInProgress);
                        continue;
                    }
                    GregorianCalendar now = new GregorianCalendar();
                    long diff = now.getTimeInMillis() - taskInProgress.getStartTime().getTimeInMillis();
                    if (diff <= this.timeout) continue;
                    futureResult.cancel(true);
                    dones.add(taskInProgress);
                }
                this.tasks.removeAll(dones);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void retrieveTimeOut() {
        long timeo = 0L;
        try {
            LiferayGroupManager groupManagement = new LiferayGroupManager();
            String scope = groupManagement.getInfrastructureScope(groupManagement.getRootVO().getGroupId());
            logger.debug("Retrieving thread pool timeout in scope: " + scope);
            ThreadPoolInfo threadPoolInfo = BuildThreadPoolInfo.build((String)scope);
            timeo = threadPoolInfo.getTimeout();
        }
        catch (Throwable e) {
            logger.error("Error retrieving thread pool timeout!", e);
            return;
        }
        if (timeo > 0L) {
            this.timeout = timeo;
            this.sce.getServletContext().setAttribute("ACCOUNTING_CLIENT_MONITOR_TIME_OUT_PERIODMILLIS", (Object)this.timeout);
        }
    }

    private void startThreadPoolTimeoutUpdateTimer() {
        try {
            this.threadPoolTimeoutUpdateTimer = new Timer();
            this.threadPoolTimeoutUpdateTimer.schedule((TimerTask)new /* Unavailable Anonymous Inner Class!! */, this.timeoutUpdate, this.timeoutUpdate);
        }
        catch (Throwable e) {
            logger.error("Error retrieving thread pool timeout!", e);
            return;
        }
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static /* synthetic */ void access$100(AccountingClientDaemon x0) {
        x0.retrieveTimeOut();
    }
}

