/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server.amservice.query;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.gcube.accounting.analytics.Filter;
import org.gcube.accounting.analytics.TemporalConstraint;
import org.gcube.accounting.datamodel.aggregation.AggregatedStorageStatusRecord;
import org.gcube.portlets.admin.accountingmanager.server.amservice.PeriodModeMap;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQuery;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQueryBuilder;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQuerySpaces;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingFilter;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingFilterSpaces;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingPeriodMode;
import org.gcube.portlets.admin.accountingmanager.shared.data.query.SeriesRequest;
import org.gcube.portlets.admin.accountingmanager.shared.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingQuery4Space
extends AccountingQueryBuilder {
    protected static Logger logger = LoggerFactory.getLogger(AccountingQuery4Space.class);
    private SeriesRequest seriesRequest;

    public AccountingQuery4Space(SeriesRequest seriesRequest) {
        this.seriesRequest = seriesRequest;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void buildOpEx() throws ServiceException {
        Calendar startCalendar = GregorianCalendar.getInstance(TemporalConstraint.DEFAULT_TIME_ZONE);
        try {
            startCalendar.setTime(this.sdf.parse(this.seriesRequest.getAccountingPeriod().getStartDate()));
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new ServiceException("Start Date not valid!");
        }
        Calendar endCalendar = GregorianCalendar.getInstance(TemporalConstraint.DEFAULT_TIME_ZONE);
        try {
            endCalendar.setTime(this.sdf.parse(this.seriesRequest.getAccountingPeriod().getEndDate()));
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new ServiceException("End Date not valid!");
        }
        endCalendar.set(11, 23);
        endCalendar.set(12, 59);
        endCalendar.set(13, 59);
        endCalendar.set(14, 999);
        TemporalConstraint temporalConstraint = new TemporalConstraint(startCalendar.getTimeInMillis(), endCalendar.getTimeInMillis(), PeriodModeMap.getMode((AccountingPeriodMode)this.seriesRequest.getAccountingPeriod().getPeriod()));
        ArrayList<Filter> filters = null;
        ArrayList accountingFilters = null;
        AccountingQuerySpaces invocation = null;
        if (this.seriesRequest != null && this.seriesRequest.getAccountingFilterDefinition() != null) {
            if (!(this.seriesRequest.getAccountingFilterDefinition() instanceof AccountingFilterSpaces)) {
                logger.error("Invalid Request: " + this.seriesRequest);
                throw new ServiceException("Invalid Request!");
            }
            AccountingFilterSpaces accountingFilterSpace = (AccountingFilterSpaces)this.seriesRequest.getAccountingFilterDefinition();
            accountingFilters = accountingFilterSpace.getFilters();
            filters = new ArrayList<Filter>();
            if (accountingFilters != null) {
                for (AccountingFilter accountigFilters : accountingFilters) {
                    Filter filter = new Filter(accountigFilters.getFilterKey().getKey(), accountigFilters.getFilterValue());
                    filters.add(filter);
                }
            }
            invocation = new AccountingQuerySpaces(AggregatedStorageStatusRecord.class, accountingFilterSpace.getSpaces(), temporalConstraint, filters);
            this.accountingQuerySpec.setOp((AccountingQuery)invocation);
            return;
        }
        logger.error("Invalid Request: " + this.seriesRequest);
        throw new ServiceException("Invalid Request!");
    }
}

