/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.accountingdashboard.server.accounting;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.VirtualHost;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.VirtualHostLocalServiceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.gcube.accounting.accounting.summary.access.impl.ContextTreeProvider;
import org.gcube.accounting.accounting.summary.access.model.ScopeDescriptor;
import org.gcube.common.portal.PortalContext;
import org.gcube.infrastructure.detachedres.detachedreslibrary.server.is.DetachedREsBuilder;
import org.gcube.infrastructure.detachedres.detachedreslibrary.shared.re.DetachedREs;
import org.gcube.infrastructure.detachedres.detachedreslibrary.shared.re.Gateway;
import org.gcube.infrastructure.detachedres.detachedreslibrary.shared.re.VO;
import org.gcube.portlets.user.accountingdashboard.server.accounting.PortalContextTreeProvider;
import org.gcube.portlets.user.accountingdashboard.server.is.BuildInfraNode;
import org.gcube.portlets.user.accountingdashboard.server.util.CocktailSort;
import org.gcube.portlets.user.accountingdashboard.shared.env.AccountingServiceType;
import org.gcube.portlets.user.accountingdashboard.shared.is.InfraNode;
import org.gcube.portlets.user.accountingdashboard.shared.options.TreeOptions;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.gcube.vomanagement.usermanagement.model.VirtualGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class PortalContextTreeProvider
implements ContextTreeProvider {
    private static GroupManager groupsManager;
    private static Logger logger;
    private AccountingServiceType accountingServiceType;
    private TreeOptions treeOptions;

    public PortalContextTreeProvider(AccountingServiceType accountingServiceType) {
        this.accountingServiceType = accountingServiceType;
        this.treeOptions = null;
    }

    public void setTreeOptions(TreeOptions treeOptions) {
        this.treeOptions = treeOptions;
    }

    public ScopeDescriptor getTree(Object context) throws Exception {
        if (context == null) {
            throw new Exception("Unable to get tree, Request is null.");
        }
        if (!(context instanceof HttpServletRequest)) {
            throw new Exception("Invalid request object : " + context);
        }
        HttpServletRequest request = (HttpServletRequest)context;
        if (this.accountingServiceType == null) {
            logger.error("Invalid AccountingServiceType requested: null");
        }
        ScopeDescriptor root = null;
        switch (1.$SwitchMap$org$gcube$portlets$user$accountingdashboard$shared$env$AccountingServiceType[this.accountingServiceType.ordinal()]) {
            case 1: {
                logger.debug("AccountingService: CurrentScope");
                break;
            }
            case 2: {
                logger.debug("AccountingService: PortalContext");
                root = this.recreateTreeForPortalContext(request);
                break;
            }
            case 3: {
                logger.debug("AccountingService: Infrastructure");
                root = this.recreateTreeForInfrastructure(request);
                break;
            }
            default: {
                logger.debug("AccountingService: CurrentScope");
            }
        }
        return root;
    }

    private ScopeDescriptor recreateTreeForInfrastructure(HttpServletRequest request) throws Exception, PortalException, SystemException {
        ScopeDescriptor infra = null;
        PortalContext portalContext = PortalContext.getConfiguration();
        String infrastructureName = portalContext.getInfrastructureName();
        String infrastructureScope = portalContext.getCurrentScope(request);
        infra = new ScopeDescriptor(infrastructureName, infrastructureScope);
        LinkedList<ScopeDescriptor> infraChildren = new LinkedList<ScopeDescriptor>();
        PortalContext pContext = PortalContext.getConfiguration();
        GCubeUser currUser = pContext.getCurrentUser(request);
        InfraNode infraNode = BuildInfraNode.build((String)infrastructureScope);
        List theGateways = new LiferayGroupManager().getGateways();
        for (GCubeGroup gCubeGroup : theGateways) {
            logger.debug("Gateway: [id=" + gCubeGroup.getGroupId() + ", name=" + gCubeGroup.getGroupName() + "]");
        }
        for (GCubeGroup gCubeGroup : theGateways) {
            logger.debug("Gateway: [id=" + gCubeGroup.getGroupId() + ", name=" + gCubeGroup.getGroupName() + "]");
            LinkedList<ScopeDescriptor> gatewayChildren = this.retrieveGatewayChildren(request, gCubeGroup.getGroupId(), currUser);
            if (infraNode != null) {
                String scopeGroup = "";
                if (gCubeGroup.getGroupName().toUpperCase().endsWith(" GATEWAY")) {
                    int l = gCubeGroup.getGroupName().length();
                    scopeGroup = gCubeGroup.getGroupName().substring(0, l - 8);
                } else {
                    scopeGroup = gCubeGroup.getGroupName();
                }
                StringBuilder gatewayScope = new StringBuilder();
                gatewayScope.append(infrastructureScope);
                gatewayScope.append("/");
                gatewayScope.append(scopeGroup);
                ScopeDescriptor infraNodeScopeDescriptor = this.createRelativeInfraNode(infraNode, gatewayScope.toString());
                if (gatewayChildren != null) {
                    gatewayChildren.addFirst(infraNodeScopeDescriptor);
                } else {
                    gatewayChildren = new LinkedList<ScopeDescriptor>();
                    gatewayChildren.add(infraNodeScopeDescriptor);
                }
            }
            ScopeDescriptor gatewayScopeDescriptor = new ScopeDescriptor(gCubeGroup.getGroupName(), gCubeGroup.getGroupId() + "");
            gatewayScopeDescriptor.setChildren((LinkedList)gatewayChildren);
            infraChildren.add(gatewayScopeDescriptor);
        }
        if (this.treeOptions != null && this.treeOptions.isShowDetachedREs()) {
            logger.debug("Show DestachedREs");
            DetachedREs detachedREs = DetachedREsBuilder.build((String)infrastructureScope);
            if (detachedREs != null && detachedREs.isEnabled()) {
                logger.debug("DetachedREs is enabled");
                if (detachedREs.getGateways() != null && !detachedREs.getGateways().isEmpty()) {
                    ArrayList gatewaysList = new ArrayList(detachedREs.getGateways().values());
                    Collections.sort(gatewaysList);
                    for (Gateway gateway : gatewaysList) {
                        ScopeDescriptor getewaySD = new ScopeDescriptor(gateway.getName(), gateway.getScope());
                        LinkedList voChildren = this.retrieveVOChildren(infraNode, gateway);
                        getewaySD.setChildren(voChildren);
                        infraChildren.add(getewaySD);
                    }
                    CocktailSort.sort(infraChildren, (CocktailSort.Order)CocktailSort.Order.DESC);
                }
            } else {
                logger.debug("DetachedREs is disabled");
            }
        }
        infra.setChildren(infraChildren);
        return infra;
    }

    private LinkedList<ScopeDescriptor> retrieveVOChildren(InfraNode infraNode, Gateway gateway) {
        LinkedList<ScopeDescriptor> vos = new LinkedList<ScopeDescriptor>();
        if (infraNode != null) {
            ScopeDescriptor infraNodeScopeDescriptor = this.createRelativeInfraNode(infraNode, gateway.getScope());
            vos.add(infraNodeScopeDescriptor);
        }
        if (gateway.getVos() != null && !gateway.getVos().isEmpty()) {
            ArrayList vosList = new ArrayList(gateway.getVos().values());
            Collections.sort(vosList);
            for (VO vo : vosList) {
                ScopeDescriptor voSD = new ScopeDescriptor(vo.getName(), vo.getScope());
                LinkedList voChildren = this.retrieveVREChildren(vo);
                voSD.setChildren(voChildren);
                vos.add(voSD);
            }
        }
        return vos;
    }

    private LinkedList<ScopeDescriptor> retrieveVREChildren(VO vo) {
        LinkedList<ScopeDescriptor> vres = new LinkedList<ScopeDescriptor>();
        if (vo.getVres() != null && !vo.getVres().isEmpty()) {
            ArrayList vresList = new ArrayList(vo.getVres().values());
            Collections.sort(vresList);
            for (org.gcube.infrastructure.detachedres.detachedreslibrary.shared.re.VRE vre : vresList) {
                ScopeDescriptor vreSD = new ScopeDescriptor(vre.getName(), vre.getScope());
                vres.add(vreSD);
            }
        }
        return vres;
    }

    private ScopeDescriptor createRelativeInfraNode(InfraNode infraNode, String scope) {
        StringBuilder absoluteScope = new StringBuilder();
        absoluteScope.append(scope);
        absoluteScope.append("/");
        absoluteScope.append(infraNode.getScope());
        ScopeDescriptor scopeDescriptor = new ScopeDescriptor(infraNode.getName(), absoluteScope.toString());
        if (infraNode.getChildren() != null && !infraNode.getChildren().isEmpty()) {
            LinkedList<ScopeDescriptor> childsScopeDescriptor = new LinkedList<ScopeDescriptor>();
            for (InfraNode child : infraNode.getChildren()) {
                ScopeDescriptor childScopeDescriptor = this.createRelativeInfraNode(child, scope);
                childsScopeDescriptor.add(childScopeDescriptor);
            }
            scopeDescriptor.setChildren(childsScopeDescriptor);
        }
        return scopeDescriptor;
    }

    private ScopeDescriptor recreateTreeForPortalContext(HttpServletRequest request) throws Exception, PortalException, SystemException {
        Group group = this.getSiteFromServletRequest(request);
        long currentSiteGroupId = group.getGroupId();
        String gatewayName = group.getName();
        PortalContext pContext = PortalContext.getConfiguration();
        GCubeUser currUser = pContext.getCurrentUser(request);
        String portalScope = pContext.getCurrentScope(currentSiteGroupId + "");
        String scopeGroup = "";
        if (gatewayName.toUpperCase().endsWith(" GATEWAY")) {
            int l = gatewayName.length();
            scopeGroup = gatewayName.substring(0, l - 8);
        } else {
            scopeGroup = gatewayName;
        }
        StringBuilder gatewayScope = new StringBuilder();
        gatewayScope.append(portalScope);
        gatewayScope.append("/");
        gatewayScope.append(scopeGroup);
        InfraNode infraNode = BuildInfraNode.build((String)portalScope);
        LinkedList<ScopeDescriptor> rootChildren = null;
        rootChildren = this.retrieveGatewayChildren(request, currentSiteGroupId, currUser);
        if (infraNode != null) {
            ScopeDescriptor infraNodeScopeDescriptor = this.createRelativeInfraNode(infraNode, gatewayScope.toString());
            if (rootChildren != null) {
                rootChildren.addFirst(infraNodeScopeDescriptor);
            } else {
                rootChildren = new LinkedList<ScopeDescriptor>();
                rootChildren.add(infraNodeScopeDescriptor);
            }
        }
        Group rootGroup = this.getSiteFromServletRequest(request);
        ScopeDescriptor root = new ScopeDescriptor(rootGroup.getDescriptiveName(), rootGroup.getGroupId() + "");
        root.setChildren(rootChildren);
        logger.debug("TREE IS {} ", (Object)root);
        return root;
    }

    private LinkedList<ScopeDescriptor> retrieveGatewayChildren(HttpServletRequest request, long currentSiteGroupId, GCubeUser currUser) throws Exception, PortalException, SystemException {
        logger.info("Retrieve Gateway Children: currentSiteGroupId=" + currentSiteGroupId);
        LinkedHashMap gatewayTree = this.getPortalSitesMappedToVRE(currUser, currentSiteGroupId);
        logger.debug("Parsing tree from gateway. Size {} ", (Object)gatewayTree.size());
        LinkedList<ScopeDescriptor> rootChildren = new LinkedList<ScopeDescriptor>();
        for (Map.Entry entry : gatewayTree.entrySet()) {
            ScopeDescriptor rootChild = new ScopeDescriptor(VRECategory.access$000((VRECategory)((VRECategory)entry.getKey())), VRECategory.access$100((VRECategory)((VRECategory)entry.getKey())) + "");
            for (VRE vre : (ArrayList)entry.getValue()) {
                rootChild.getChildren().add(new ScopeDescriptor(VRE.access$200((VRE)vre), VRE.access$300((VRE)vre)));
            }
            rootChildren.add(rootChild);
        }
        return rootChildren;
    }

    private LinkedHashMap<VRECategory, ArrayList<VRE>> getPortalSitesMappedToVRE(GCubeUser currUser, long currentSiteGroupId) throws Exception {
        LinkedHashMap<VRECategory, ArrayList<VRE>> toReturn = new LinkedHashMap<VRECategory, ArrayList<VRE>>();
        List currentSiteVGroups = groupsManager.getVirtualGroups(currentSiteGroupId);
        for (VirtualGroup vg : currentSiteVGroups) {
            ArrayList toCreate = new ArrayList();
            VRECategory cat = new VRECategory(this, 1L, vg.getName(), vg.getDescription());
            toReturn.put(cat, toCreate);
        }
        GCubeGroup rootGroupVO = groupsManager.getRootVO();
        try {
            logger.debug("root: " + rootGroupVO.getGroupName());
        }
        catch (NullPointerException e) {
            logger.error("Cannot find root organziation, please check gcube-data.properties file in $CATALINA_HOME/conf folder, unless your installing the Bundle");
            return toReturn;
        }
        List currUserGroups = new ArrayList();
        if (currUser != null) {
            currUserGroups = groupsManager.listGroupsByUser(currUser.getUserId());
        }
        for (GCubeGroup vOrg : rootGroupVO.getChildren()) {
            for (GCubeGroup vreSite : vOrg.getChildren()) {
                long vreID = vreSite.getGroupId();
                String vreName = vreSite.getGroupName();
                String vreDescription = vreSite.getDescription();
                long logoId = vreSite.getLogoId();
                String vreLogoURL = groupsManager.getGroupLogoURL(logoId);
                String infraScope = groupsManager.getInfrastructureScope(vreSite.getGroupId());
                String friendlyURL = "/group" + vreSite.getFriendlyURL();
                List vreGroups = groupsManager.getVirtualGroups(vreID);
                for (VirtualGroup vreGroup : vreGroups) {
                    for (VRECategory vre : toReturn.keySet()) {
                        if (vre.getName().compareTo(vreGroup.getName()) != 0) continue;
                        ArrayList<VRE> toUpdate = toReturn.get(vre);
                        VRE toAdd = new VRE(this, vreName, vreDescription, vreID, friendlyURL, infraScope);
                        toUpdate.add(toAdd);
                    }
                }
            }
        }
        for (VRECategory cat : toReturn.keySet()) {
            ArrayList<VRE> toSort = toReturn.get(cat);
            Collections.sort(toSort);
        }
        return toReturn;
    }

    private Group getSiteFromServletRequest(HttpServletRequest request) throws PortalException, SystemException {
        String serverName = request.getServerName();
        logger.debug("currentHost is " + serverName);
        Group site = null;
        List vHosts = VirtualHostLocalServiceUtil.getVirtualHosts((int)0, (int)VirtualHostLocalServiceUtil.getVirtualHostsCount());
        for (VirtualHost virtualHost : vHosts) {
            logger.debug("Found " + virtualHost.getHostname());
            if (virtualHost.getHostname().compareTo("localhost") == 0 || virtualHost.getLayoutSetId() == 0L || virtualHost.getHostname().compareTo(serverName) != 0) continue;
            long layoutSetId = virtualHost.getLayoutSetId();
            site = LayoutSetLocalServiceUtil.getLayoutSet((long)layoutSetId).getGroup();
            logger.debug("Found match! Your site is " + site.getName());
            return site;
        }
        return null;
    }

    static {
        logger = LoggerFactory.getLogger(PortalContextTreeProvider.class);
        groupsManager = new LiferayGroupManager();
    }
}

