<%@ include file="/init.jsp" %>

<liferay-portlet:actionURL portletConfiguration="true" var="configurationURL" />

<%
String appURL_cfg = GetterUtil.getString(portletPreferences.getValue("appURL", StringPool.BLANK));
String appURLTokenParam_cfg = GetterUtil.getString(portletPreferences.getValue("appURLTokenParam", StringPool.BLANK));
Integer iFrameHeightParam_cfg = GetterUtil.getInteger(portletPreferences.getValue("iFrameHeightParam", "1000"));
boolean newAuthVersionPreference_cfg = GetterUtil.getBoolean(portletPreferences.getValue("newAuthVersionPreference", StringPool.FALSE));
boolean newWindowPreference_cfg = GetterUtil.getBoolean(portletPreferences.getValue("newWindowPreference", StringPool.FALSE));
String applicationNameParam_cfg = GetterUtil.getString(portletPreferences.getValue("applicationNameParam", "the Application"));
if (applicationNameParam_cfg.equals(""))
    applicationNameParam_cfg = "the Application";
%>

<div class="portlet-configuration-body-content">
    <div class="sheet">
        <div class="panel-group panel-group-flush">
            
            <aui:form action="<%=configurationURL%>" method="post" name="fm">
                <aui:input name="<%=Constants.CMD%>" type="hidden" value="<%=Constants.UPDATE%>" />

                <!-- Basic Configuration Panel -->
                <aui:fieldset collapsed="<%= false %>" collapsible="<%= true %>" label="Basic Configuration">
                    
                    <aui:input 
                        style="width: 100%;" 
                        name="preferences--appURL--"
                        type="text" 
                        cssClass="text long-field" 
                        showRequiredLabel="true"
                        label="Application URL" 
                        placeholder="Application URL"
                        helpMessage="Actual endpoint of the external web-application (must start with https://)"
                        value="<%=appURL_cfg%>" 
                        required="true" 
                    />
                    
                    <aui:input 
                        type="text" 
                        name="preferences--applicationNameParam--"
                        cssClass="text medium-field"
                        label="Application Name" 
                        placeholder="The name of the application (e.g. Galaxy, ShareLatex)"
                        helpMessage="Enter the name of the application (e.g. Galaxy, ShareLatex etc.)"
                        value="<%=applicationNameParam_cfg%>" 
                    />
                    
                </aui:fieldset>
                
                <!-- Security Configuration Panel -->
                <aui:fieldset collapsed="<%= true %>" collapsible="<%= true %>" label="Security Configuration">
                    
                    <aui:input 
                        type="text" 
                        name="preferences--appURLTokenParam--"
                        cssClass="text medium-field" 
                        label="Token Parameter Name"
                        placeholder="Parameter name"
                        helpMessage="Name of the Security Token Parameter (e.g gcube-token) expected by the web-application in the URL"
                        value="<%=appURLTokenParam_cfg%>" 
                    />
                    
                    <aui:input 
                        name="preferences--newAuthVersionPreference--" 
                        type="checkbox"
                        label="Use new IAM solution"
                        helpMessage="If checked will not pass the (legacy) token, it will pass the encoded current context"
                        checked="<%=newAuthVersionPreference_cfg%>" 
                    />
                    
                </aui:fieldset>
                
                <!-- Display Options Panel -->
                <aui:fieldset collapsed="<%= true %>" collapsible="<%= true %>" label="Display Options">
                    
                    <aui:input 
                        type="number" 
                        name="preferences--iFrameHeightParam--"
                        cssClass="text medium-field"
                        label="iFrame Height (pixels)" 
                        placeholder="in Pixels"
                        helpMessage="Enter the height in pixels of the iFrame Height (default 1000)"
                        value="<%=iFrameHeightParam_cfg%>" 
                        min="100"
                        max="5000"
                    />
                    
                    <aui:input 
                        name="preferences--newWindowPreference--" 
                        type="checkbox"
                        label="Open in new window"
                        helpMessage="If checked will use a new tab instead of the iFrame (beware of the popup blocker)"
                        checked="<%=newWindowPreference_cfg%>" 
                    />
                    
                </aui:fieldset>
                
                <aui:button-row>
                    <aui:button type="submit" value="Save" />
                    <aui:button type="cancel" />
                </aui:button-row>
                
            </aui:form>
        </div>
    </div>
</div>

<aui:script>
    AUI().ready(function(A) {
        // Use modern event handling instead of deprecated unload events
        var form = A.one('#<portlet:namespace />fm');
        
        if (form) {
            // Form validation
            var validator = new A.FormValidator({
                boundingBox: form,
                rules: {
                    '<portlet:namespace />preferences--appURL--': {
                        required: true,
                        url: true
                    },
                    '<portlet:namespace />preferences--iFrameHeightParam--': {
                        required: true,
                        range: [100, 5000]
                    }
                },
                fieldStrings: {
                    '<portlet:namespace />preferences--appURL--': {
                        required: 'Application URL is required.',
                        url: 'Please enter a valid URL (http:// or https://).'
                    },
                    '<portlet:namespace />preferences--iFrameHeightParam--': {
                        required: 'iFrame height is required.',
                        range: 'iFrame height must be between 100 and 5000 pixels.'
                    }
                }
            });
            
            // Handle form submission with modern approach
            form.on('submit', function(event) {
                if (!validator.hasErrors()) {
                    // Form is valid, allow submission
                    return true;
                } else {
                    // Prevent submission if validation fails
                    event.preventDefault();
                    return false;
                }
            });
        }
    });
</aui:script>

<style>
.portlet-configuration-body-content {
    padding: 20px;
}

.portlet-configuration-body-content .sheet {
    background: #fff;
    border: 1px solid #e7e7ed;
    border-radius: 4px;
    padding: 24px;
    margin-bottom: 20px;
}

.portlet-configuration-body-content .control-group {
    margin-bottom: 20px;
}

.portlet-configuration-body-content .help-block {
    color: #6b6c7e;
    font-size: 13px;
    margin-top: 5px;
}

.portlet-configuration-body-content .fieldset {
    border: none;
    margin-bottom: 24px;
    padding: 0;
}

.portlet-configuration-body-content .fieldset legend {
    border-bottom: 1px solid #e7e7ed;
    color: #272833;
    font-size: 16px;
    font-weight: 600;
    margin-bottom: 16px;
    padding-bottom: 8px;
    width: 100%;
}
</style>