/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.vreappintegration.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import java.io.IOException;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"com.liferay.portlet.display-category=category.gcube", "com.liferay.portlet.header-portlet-css=/css/main.css", "com.liferay.portlet.instanceable=true", "com.liferay.portlet.preferences-owned-by-group=true", "com.liferay.portlet.preferences-unique-per-layout=false", "com.liferay.portlet.use-default-template=true", "javax.portlet.display-name=VRE App Integration", "javax.portlet.init-param.template-path=/", "javax.portlet.init-param.view-template=/view.jsp", "javax.portlet.init-param.config-template=/config.jsp", "javax.portlet.name=org_gcube_portlets_user_vreappintegration_VREAppIntegrationPortlet", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=power-user,user", "javax.portlet.preferences=classpath:/META-INF/portlet-preferences/default-portlet-preferences.xml", "com.liferay.portlet.configuration-action-class=org.gcube.portlets.user.vreappintegration.action.VREAppConfigurationAction"}, service={Portlet.class})
public class VREAppIntegrationPortlet
extends MVCPortlet {
    private static final Log _log = LogFactoryUtil.getLog(VREAppIntegrationPortlet.class);
    @Reference
    private UserLocalService userLocalService;

    public void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        try {
            ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            if (themeDisplay != null) {
                User user = themeDisplay.getUser();
                String username = user.getScreenName();
                long groupId = themeDisplay.getScopeGroupId();
                String context = this.getCurrentContext(themeDisplay);
                _log.debug((Object)("VREAppIntegration doView - User: " + username + ", Context: " + context));
                String token = this.getCurrentUserToken(context, username);
                if (token != null) {
                    renderRequest.setAttribute("securityToken", (Object)token);
                    String encodedContext = context != null ? context.replaceAll("/", "%2F") : "";
                    renderRequest.setAttribute("encodedContext", (Object)encodedContext);
                    _log.debug((Object)("Generated token for user: " + username + " in context: " + context));
                } else {
                    _log.warn((Object)("Could not generate token for user: " + username + " in context: " + context));
                }
            } else {
                _log.error((Object)"ThemeDisplay is null - cannot retrieve user information");
            }
        }
        catch (Exception e) {
            _log.error((Object)"Error in VREAppIntegration doView", (Throwable)e);
        }
        super.doView(renderRequest, renderResponse);
    }

    private String getCurrentContext(ThemeDisplay themeDisplay) {
        try {
            long groupId = themeDisplay.getScopeGroupId();
            String context = "/gcube/devsec/VRE-" + groupId;
            _log.debug((Object)("Using mock gCube context: " + context + " for groupId: " + groupId));
            return context;
        }
        catch (Exception e) {
            _log.error((Object)("Error retrieving gCube context: " + e.getMessage()), (Throwable)e);
            return "/gcube/devsec";
        }
    }

    private String getCurrentUserToken(String context, String username) {
        String userToken = null;
        try {
            userToken = "gcube-token-" + username + "-" + context.hashCode() + "-" + System.currentTimeMillis();
            _log.debug((Object)("Generated mock token for user: " + username + " in context: " + context));
        }
        catch (Exception e) {
            _log.error((Object)("Error generating gCube token: " + e.getMessage()), (Throwable)e);
            userToken = "fallback-token-" + username + "-" + System.currentTimeMillis();
        }
        return userToken;
    }
}

