/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.softwaregateway.client.util;

import java.util.List;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.scope.GCUBEScope;

public class ISUtil {
    public static EndpointReferenceType getSoftwareGatewayEndpoint(GCUBEScope scope) throws Exception {
        return ISUtil.getServicePortTypeEndpoint(scope, "VREManagement", "SoftwareGateway", "gcube/vremanagement/softwaregateway/Registration", false);
    }

    public static EndpointReferenceType getServicePortTypeEndpoint(GCUBEScope scope, String serviceClass, String serviceName, String portTypeFullName, boolean scopeSpecific) throws Exception {
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBERIQuery query = (GCUBERIQuery)client.getQuery(GCUBERIQuery.class);
        query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//ServiceClass", serviceClass), new AtomicCondition("//ServiceName", serviceName)});
        List RIs = client.execute((ISQuery)query, scope);
        if (RIs.size() == 0) {
            throw new RuntimeException("No services found");
        }
        GCUBERunningInstance serviceRI = null;
        if (RIs.size() > 1) {
            if (!scopeSpecific) {
                throw new RuntimeException("More than one service found");
            }
            for (GCUBERunningInstance ri : RIs) {
                if (ri.getScopes().size() != 1 || !ri.getScopes().containsKey(scope.toString())) continue;
                serviceRI = ri;
                break;
            }
            if (serviceRI == null) {
                throw new RuntimeException("No specific RI instaces found for scope " + scope);
            }
        } else {
            serviceRI = (GCUBERunningInstance)RIs.get(0);
        }
        EndpointReferenceType epr = serviceRI.getAccessPoint().getEndpoint(portTypeFullName);
        return epr;
    }
}

