/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.searchsystem.searchsystemservice;

import gr.uoa.di.madgik.commons.channel.proxy.tcp.ChannelTCPConnManagerEntry;
import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.commons.server.PortRange;
import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.commons.server.TCPConnectionManagerConfig;
import gr.uoa.di.madgik.environment.hint.EnvHint;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.environment.hint.NamedEnvHint;
import gr.uoa.di.madgik.execution.engine.ExecutionEngine;
import gr.uoa.di.madgik.execution.engine.ExecutionEngineConfig;
import gr.uoa.di.madgik.execution.plan.element.invocable.tcpserver.ExecEngCallbackTCPConnManagerEntry;
import gr.uoa.di.madgik.execution.plan.element.invocable.tcpserver.ExecEngTCPConnManagerEntry;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPStoreConnectionHandler;
import gr.uoa.di.madgik.is.InformationSystem;
import java.util.ArrayList;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.searchsystem.environmentadaptor.ResourceRegistryAdapter;

public class ServiceContext
extends GCUBEServiceContext {
    private static final int MAXATTEMPTS = 10;
    private EnvHintCollection hints = new EnvHintCollection();
    private static ServiceContext cache = new ServiceContext();
    static GCUBELog logger = new GCUBELog(ServiceContext.class);

    public static ServiceContext getContext() {
        return cache;
    }

    private ServiceContext() {
    }

    public String getJNDIName() {
        return "gcube/searchsystem/SearchSystemService";
    }

    protected void onReady() throws Exception {
        super.onReady();
        EnvHintCollection Hints = new EnvHintCollection();
        Hints.AddHint(new NamedEnvHint("InformationSystemRIContainerServiceClass", new EnvHint(ServiceContext.getContext().getService().getServiceClass())));
        Hints.AddHint(new NamedEnvHint("InformationSystemRIContainerServiceName", new EnvHint(ServiceContext.getContext().getService().getServiceName())));
        logger.info((Object)"Initalizing TCPManager");
        PortRange pr = new PortRange(4000, 5000);
        ArrayList<PortRange> l = new ArrayList<PortRange>();
        l.add(pr);
        TCPConnectionManager.Init((TCPConnectionManagerConfig)new TCPConnectionManagerConfig(GHNContext.getContext().getHostname(), l, true));
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPConnectionHandler());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPStoreConnectionHandler());
        logger.info((Object)"Initalizing Execution Engine Environment");
        logger.info((Object)"Registering entries");
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new ExecEngTCPConnManagerEntry());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new ExecEngCallbackTCPConnManagerEntry());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new ChannelTCPConnManagerEntry());
        logger.info((Object)"Initializing Execution Engine");
        ExecutionEngine.Init((ExecutionEngineConfig)new ExecutionEngineConfig(0));
        logger.info((Object)"Collecting Environment Hints");
        logger.info((Object)"Initializing Information System Provider");
        InformationSystem.Init((String)this.GetInformationSystemProvider(), (EnvHintCollection)Hints);
        this.parseOperatorNodeSelectorThreshold();
        this.parseComplexPlanLevels();
        this.parseComplexPlanNumNodes();
        this.parseMaxCollocationCost();
        this.parseDatasourceNodeSelector();
        this.parseDatasourceNodeSelectorTieBreaker();
        this.parseOperatorNodeSelector();
        this.parseOperatorNodeSelectorTieBreaker();
        this.parseNodeAssignmentPolicy();
        this.parseExcludeLocal();
        for (int attempts = 0; attempts < 10; ++attempts) {
            if (ResourceRegistryAdapter.initializeAdapter()) {
                return;
            }
            Thread.sleep(1000L);
        }
        logger.error((Object)("context status : " + ServiceContext.getContext().getStatus()));
        ServiceContext.getContext().setStatus(GCUBEServiceContext.Status.FAILED);
        logger.error((Object)"Could not initialize Resource Registry Adaptor");
    }

    private Float parseOperatorNodeSelectorThreshold() {
        Object ct = ServiceContext.getContext().getProperty("operatorNodeSelectorThreshold", new boolean[]{false});
        if (ct == null) {
            return null;
        }
        this.hints.AddHint(new NamedEnvHint("OperatorNodeSelectorThreshold", new EnvHint(ct.toString())));
        logger.info((Object)("Using operator node selector threshold: " + ct.toString()));
        return (Float)ct;
    }

    private Integer parseComplexPlanLevels() {
        Object ct = ServiceContext.getContext().getProperty("complexPlanLevels", new boolean[]{false});
        if (ct == null) {
            return null;
        }
        this.hints.AddHint(new NamedEnvHint("ComplexPlanLevels", new EnvHint(ct.toString())));
        logger.info((Object)("Using complex plan levels: " + ct.toString()));
        return (Integer)ct;
    }

    private Integer parseComplexPlanNumNodes() {
        Object ct = ServiceContext.getContext().getProperty("complexPlanNumNodes", new boolean[]{false});
        if (ct == null) {
            return null;
        }
        this.hints.AddHint(new NamedEnvHint("ComplexPlanNumNodes", new EnvHint(ct.toString())));
        logger.info((Object)("Using complex plan num nodes: " + ct.toString()));
        return (Integer)ct;
    }

    private Float parseMaxCollocationCost() {
        Object ct = ServiceContext.getContext().getProperty("maximumCollocationCost", new boolean[]{false});
        if (ct == null) {
            return null;
        }
        this.hints.AddHint(new NamedEnvHint("MaxCollocationCost", new EnvHint(ct.toString())));
        logger.info((Object)("Using maximum collocation cost: " + ct.toString()));
        return (Float)ct;
    }

    private String parseNodeAssignmentPolicy() {
        Object ap = ServiceContext.getContext().getProperty("nodeAssignmentPolicy", new boolean[]{false});
        if (ap == null) {
            return null;
        }
        this.hints.AddHint(new NamedEnvHint("NodeAssignmentPolicy", new EnvHint(ap.toString())));
        logger.info((Object)("Using node assignment policy: " + ap.toString()));
        return ap.toString();
    }

    private Boolean parseExcludeLocal() {
        Object el = ServiceContext.getContext().getProperty("excludeLocal", new boolean[]{false});
        if (el == null) {
            return null;
        }
        this.hints.AddHint(new NamedEnvHint("ExcludeLocal", new EnvHint(el.toString())));
        logger.info((Object)(((Boolean)el != false ? "E" : "Not e") + "xcluding local node"));
        return (Boolean)el;
    }

    private String parseDatasourceNodeSelector() {
        Object ns = ServiceContext.getContext().getProperty("datasourceNodeSelector", new boolean[]{false});
        if (ns == null) {
            return null;
        }
        this.hints.AddHint(new NamedEnvHint("DataSourceNodeSelector", new EnvHint(ns.toString())));
        logger.info((Object)("Using data source node selector: " + ns.toString()));
        return (String)ns;
    }

    private String parseDatasourceNodeSelectorTieBreaker() {
        Object ns = ServiceContext.getContext().getProperty("datasourceNodeSelectorTieBreaker", new boolean[]{false});
        if (ns == null) {
            return null;
        }
        this.hints.AddHint(new NamedEnvHint("DataSourceNodeSelectorTieBreaker", new EnvHint(ns.toString())));
        logger.info((Object)("Using data source node selector tie breaker: " + ns.toString()));
        return (String)ns;
    }

    private String parseOperatorNodeSelectorTieBreaker() {
        Object ns = ServiceContext.getContext().getProperty("operatorNodeSelectorTieBreaker", new boolean[]{false});
        if (ns == null) {
            return null;
        }
        this.hints.AddHint(new NamedEnvHint("OperatorNodeSelectorTieBreaker", new EnvHint(ns.toString())));
        logger.info((Object)("Using operator node selector tie breaker: " + ns.toString()));
        return (String)ns;
    }

    private String parseOperatorNodeSelector() {
        Object ns = ServiceContext.getContext().getProperty("operatorNodeSelector", new boolean[]{false});
        if (ns == null) {
            return null;
        }
        this.hints.AddHint(new NamedEnvHint("OperatorNodeSelector", new EnvHint(ns.toString())));
        logger.info((Object)("Using operator node selector: " + ns.toString()));
        return (String)ns;
    }

    private String GetInformationSystemProvider() {
        Object informationProviderObj = ServiceContext.getContext().getProperty("providerInformationName", new boolean[]{false});
        if (informationProviderObj == null) {
            return null;
        }
        return informationProviderObj.toString();
    }

    public EnvHintCollection getHints() {
        return this.hints;
    }
}

