/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.client.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gcube.common.clients.exceptions.DiscoveryException;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.gcube.resources.discovery.icclient.ICFactory;

public abstract class Discover {
    protected static SimpleQuery getGCoreEndpointQuery() {
        return ICFactory.queryFor(GCoreEndpoint.class).addCondition("$resource/Profile/ServiceClass/text() eq '%s'".formatted("org.gcube.vremanagement")).addCondition("$resource/Profile/ServiceName/text() eq '%s'".formatted("smart-executor")).addCondition("starts-with($resource/Profile/Version/text(),'2')").addCondition("$resource/Profile/DeploymentData/Status/text() eq 'ready'".formatted(new Object[0])).addVariable("$entry", "$resource/Profile/AccessPoint/RunningInstanceInterfaces/Endpoint").addCondition("$entry/@EntryName eq '%s'".formatted("org.gcube.vremanagement.executor.ResourceInitializer")).setResult("$entry/text()");
    }

    protected static SimpleQuery getServiceEndpointQuery() {
        return ICFactory.queryFor(ServiceEndpoint.class).addCondition("$resource/Profile/Category/text() eq '%s'".formatted("org.gcube.vremanagement")).addCondition("$resource/Profile/Name/text() eq '%s'".formatted("smart-executor")).setResult("$resource");
    }

    protected static SimpleQuery filterByPluginName(SimpleQuery serviceEndpointQuery, String pluginName) {
        return serviceEndpointQuery.addVariable("$accessPoint", "$resource/Profile/AccessPoint").addCondition("$accessPoint/Interface/Endpoint/@EntryName eq '%s'".formatted(pluginName));
    }

    protected static SimpleQuery filterByCapabilities(SimpleQuery serviceEndpointQuery, Map<String, String> capabilities) {
        if (capabilities != null && !capabilities.isEmpty()) {
            int i = 0;
            for (String key : capabilities.keySet()) {
                String propertyVariableName = "$property%d".formatted(i);
                serviceEndpointQuery.addVariable(propertyVariableName, "$accessPoint/Properties/Property").addCondition("%s/Name/text() eq '%s'".formatted(propertyVariableName, key)).addCondition("%s/Value/text() eq '%s'".formatted(propertyVariableName, capabilities.get(key)));
                ++i;
            }
        }
        return serviceEndpointQuery;
    }

    public static List<String> getInstancesAddress(String pluginName) throws DiscoveryException {
        return Discover.getInstancesAddress(pluginName, null);
    }

    public static List<String> getInstancesAddress(String pluginName, Map<String, String> capabilities) throws DiscoveryException {
        SimpleQuery serviceEndpointQuery = Discover.getServiceEndpointQuery();
        serviceEndpointQuery = Discover.filterByPluginName(serviceEndpointQuery, pluginName);
        serviceEndpointQuery = Discover.filterByCapabilities(serviceEndpointQuery, capabilities);
        List serviceEndpoints = ICFactory.clientFor(ServiceEndpoint.class).submit((Query)serviceEndpointQuery);
        if (serviceEndpoints.size() == 0) {
            throw new DiscoveryException("No running SmartExecutor wich match the requested conditions");
        }
        return Discover.getInstancesAddress(serviceEndpoints);
    }

    protected static List<String> getInstancesAddress(List<ServiceEndpoint> serviceEndpoints) throws DiscoveryException {
        ArrayList<String> addresses = new ArrayList<String>();
        for (ServiceEndpoint serviceEndpoint : serviceEndpoints) {
            SimpleQuery gCoreEndpointDiscoveryQuery = Discover.getGCoreEndpointQuery();
            String hostname = serviceEndpoint.profile().platform().name();
            gCoreEndpointDiscoveryQuery.addCondition("contains($entry/string(),'%s')".formatted(hostname));
            addresses.addAll(ICFactory.client().submit((Query)gCoreEndpointDiscoveryQuery));
        }
        return addresses;
    }

    public static List<String> getInstancesAddress() throws DiscoveryException {
        SimpleQuery gCoreEndpointDiscoveryQuery = Discover.getGCoreEndpointQuery();
        List addresses = ICFactory.client().submit((Query)gCoreEndpointDiscoveryQuery);
        return addresses;
    }
}

