/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.audit.dm.entity;

import com.finconsgroup.itserr.marketplace.audit.dm.entity.AuditLogEntity;
import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import java.time.Instant;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.hibernate.annotations.JdbcTypeCode;

@Entity
@Table(name="audit_log")
public class AuditLogEntity
extends AbstractUUIDEntity {
    @Column(name="event_source", nullable=false, length=100)
    private String eventSource;
    @Column(name="event_type", nullable=false, length=100)
    private String eventType;
    @Column(name="user_id")
    private UUID userId;
    @Column(name="user_username", length=100)
    private String userUsername;
    @Column(name="user_name", length=255)
    private String userName;
    @Column(name="resource_id", nullable=false, length=100)
    private String resourceId;
    @Column(name="resource_name", length=255)
    private String resourceName;
    @Column(name="resource_title", length=255)
    private String resourceTitle;
    @Column(name="resource_category", length=255)
    private String resourceCategory;
    @Column(name="resource_status", length=100)
    private String resourceStatus;
    @Column(name="event_message", length=800)
    private String eventMessage;
    @JdbcTypeCode(value=3001)
    @Column(name="event_additional_data", columnDefinition="json")
    private Map<String, Object> eventAdditionalData;
    @Column(name="event_action_time", nullable=false)
    private Instant eventActionTime;
    @Column(name="event_creation_time", nullable=false)
    private Instant eventCreationTime;
    @Column(name="creation_time", nullable=false, updatable=false)
    private Instant creationTime;

    public void prePersist() {
        super.prePersist();
        Instant now = Instant.now();
        if (this.creationTime == null) {
            this.creationTime = now;
        }
    }

    @PreUpdate
    public void onUpdate() {
        throw new UnsupportedOperationException("Update not supported");
    }

    @Generated
    protected AuditLogEntity(AuditLogEntityBuilder<?, ?> b) {
        super(b);
        this.eventSource = b.eventSource;
        this.eventType = b.eventType;
        this.userId = b.userId;
        this.userUsername = b.userUsername;
        this.userName = b.userName;
        this.resourceId = b.resourceId;
        this.resourceName = b.resourceName;
        this.resourceTitle = b.resourceTitle;
        this.resourceCategory = b.resourceCategory;
        this.resourceStatus = b.resourceStatus;
        this.eventMessage = b.eventMessage;
        this.eventAdditionalData = b.eventAdditionalData;
        this.eventActionTime = b.eventActionTime;
        this.eventCreationTime = b.eventCreationTime;
        this.creationTime = b.creationTime;
    }

    @Generated
    public static AuditLogEntityBuilder<?, ?> builder() {
        return new AuditLogEntityBuilderImpl();
    }

    @Generated
    public String getEventSource() {
        return this.eventSource;
    }

    @Generated
    public String getEventType() {
        return this.eventType;
    }

    @Generated
    public UUID getUserId() {
        return this.userId;
    }

    @Generated
    public String getUserUsername() {
        return this.userUsername;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getResourceId() {
        return this.resourceId;
    }

    @Generated
    public String getResourceName() {
        return this.resourceName;
    }

    @Generated
    public String getResourceTitle() {
        return this.resourceTitle;
    }

    @Generated
    public String getResourceCategory() {
        return this.resourceCategory;
    }

    @Generated
    public String getResourceStatus() {
        return this.resourceStatus;
    }

    @Generated
    public String getEventMessage() {
        return this.eventMessage;
    }

    @Generated
    public Map<String, Object> getEventAdditionalData() {
        return this.eventAdditionalData;
    }

    @Generated
    public Instant getEventActionTime() {
        return this.eventActionTime;
    }

    @Generated
    public Instant getEventCreationTime() {
        return this.eventCreationTime;
    }

    @Generated
    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public void setEventSource(String eventSource) {
        this.eventSource = eventSource;
    }

    @Generated
    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    @Generated
    public void setUserId(UUID userId) {
        this.userId = userId;
    }

    @Generated
    public void setUserUsername(String userUsername) {
        this.userUsername = userUsername;
    }

    @Generated
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Generated
    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    @Generated
    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    @Generated
    public void setResourceTitle(String resourceTitle) {
        this.resourceTitle = resourceTitle;
    }

    @Generated
    public void setResourceCategory(String resourceCategory) {
        this.resourceCategory = resourceCategory;
    }

    @Generated
    public void setResourceStatus(String resourceStatus) {
        this.resourceStatus = resourceStatus;
    }

    @Generated
    public void setEventMessage(String eventMessage) {
        this.eventMessage = eventMessage;
    }

    @Generated
    public void setEventAdditionalData(Map<String, Object> eventAdditionalData) {
        this.eventAdditionalData = eventAdditionalData;
    }

    @Generated
    public void setEventActionTime(Instant eventActionTime) {
        this.eventActionTime = eventActionTime;
    }

    @Generated
    public void setEventCreationTime(Instant eventCreationTime) {
        this.eventCreationTime = eventCreationTime;
    }

    @Generated
    public void setCreationTime(Instant creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuditLogEntity)) {
            return false;
        }
        AuditLogEntity other = (AuditLogEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$eventSource = this.getEventSource();
        String other$eventSource = other.getEventSource();
        if (this$eventSource == null ? other$eventSource != null : !this$eventSource.equals(other$eventSource)) {
            return false;
        }
        String this$eventType = this.getEventType();
        String other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !this$eventType.equals(other$eventType)) {
            return false;
        }
        UUID this$userId = this.getUserId();
        UUID other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        String this$userUsername = this.getUserUsername();
        String other$userUsername = other.getUserUsername();
        if (this$userUsername == null ? other$userUsername != null : !this$userUsername.equals(other$userUsername)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$resourceId = this.getResourceId();
        String other$resourceId = other.getResourceId();
        if (this$resourceId == null ? other$resourceId != null : !this$resourceId.equals(other$resourceId)) {
            return false;
        }
        String this$resourceName = this.getResourceName();
        String other$resourceName = other.getResourceName();
        if (this$resourceName == null ? other$resourceName != null : !this$resourceName.equals(other$resourceName)) {
            return false;
        }
        String this$resourceTitle = this.getResourceTitle();
        String other$resourceTitle = other.getResourceTitle();
        if (this$resourceTitle == null ? other$resourceTitle != null : !this$resourceTitle.equals(other$resourceTitle)) {
            return false;
        }
        String this$resourceCategory = this.getResourceCategory();
        String other$resourceCategory = other.getResourceCategory();
        if (this$resourceCategory == null ? other$resourceCategory != null : !this$resourceCategory.equals(other$resourceCategory)) {
            return false;
        }
        String this$resourceStatus = this.getResourceStatus();
        String other$resourceStatus = other.getResourceStatus();
        if (this$resourceStatus == null ? other$resourceStatus != null : !this$resourceStatus.equals(other$resourceStatus)) {
            return false;
        }
        String this$eventMessage = this.getEventMessage();
        String other$eventMessage = other.getEventMessage();
        if (this$eventMessage == null ? other$eventMessage != null : !this$eventMessage.equals(other$eventMessage)) {
            return false;
        }
        Map this$eventAdditionalData = this.getEventAdditionalData();
        Map other$eventAdditionalData = other.getEventAdditionalData();
        if (this$eventAdditionalData == null ? other$eventAdditionalData != null : !((Object)this$eventAdditionalData).equals(other$eventAdditionalData)) {
            return false;
        }
        Instant this$eventActionTime = this.getEventActionTime();
        Instant other$eventActionTime = other.getEventActionTime();
        if (this$eventActionTime == null ? other$eventActionTime != null : !((Object)this$eventActionTime).equals(other$eventActionTime)) {
            return false;
        }
        Instant this$eventCreationTime = this.getEventCreationTime();
        Instant other$eventCreationTime = other.getEventCreationTime();
        if (this$eventCreationTime == null ? other$eventCreationTime != null : !((Object)this$eventCreationTime).equals(other$eventCreationTime)) {
            return false;
        }
        Instant this$creationTime = this.getCreationTime();
        Instant other$creationTime = other.getCreationTime();
        return !(this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AuditLogEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $eventSource = this.getEventSource();
        result = result * 59 + ($eventSource == null ? 43 : $eventSource.hashCode());
        String $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : $eventType.hashCode());
        UUID $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        String $userUsername = this.getUserUsername();
        result = result * 59 + ($userUsername == null ? 43 : $userUsername.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $resourceId = this.getResourceId();
        result = result * 59 + ($resourceId == null ? 43 : $resourceId.hashCode());
        String $resourceName = this.getResourceName();
        result = result * 59 + ($resourceName == null ? 43 : $resourceName.hashCode());
        String $resourceTitle = this.getResourceTitle();
        result = result * 59 + ($resourceTitle == null ? 43 : $resourceTitle.hashCode());
        String $resourceCategory = this.getResourceCategory();
        result = result * 59 + ($resourceCategory == null ? 43 : $resourceCategory.hashCode());
        String $resourceStatus = this.getResourceStatus();
        result = result * 59 + ($resourceStatus == null ? 43 : $resourceStatus.hashCode());
        String $eventMessage = this.getEventMessage();
        result = result * 59 + ($eventMessage == null ? 43 : $eventMessage.hashCode());
        Map $eventAdditionalData = this.getEventAdditionalData();
        result = result * 59 + ($eventAdditionalData == null ? 43 : ((Object)$eventAdditionalData).hashCode());
        Instant $eventActionTime = this.getEventActionTime();
        result = result * 59 + ($eventActionTime == null ? 43 : ((Object)$eventActionTime).hashCode());
        Instant $eventCreationTime = this.getEventCreationTime();
        result = result * 59 + ($eventCreationTime == null ? 43 : ((Object)$eventCreationTime).hashCode());
        Instant $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        return result;
    }

    @Generated
    public AuditLogEntity() {
    }
}

