package com.finconsgroup.itserr.marketplace.discussion.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.List;

/**
 * DTO for finding user profile info by provided principals.
 */
@Schema(name = "FindUserProfilesByPrincipalsDto", description = "DTO for finding user profile details by provided principals")
@Data
@Builder
@AllArgsConstructor
public class InputFindUserProfilesByPrincipalsDto {

    @NotEmpty
    @Schema(
        description = "Principals of the user profiles to retrieve details",
        example ="[\"antonio.manganelli89674\", \"roberto.red74\"]")
        List<String> principals;
}
