package com.finconsgroup.itserr.marketplace.discussion.bs.messaging.dto;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.util.List;
import java.util.Set;
import java.util.UUID;

/**
 * DTO that carries additional discussion thread-specific fields within a messaging event payload.
 * <p>
 * This object is nested inside {@link com.finconsgroup.itserr.messaging.dto.MessagingEventDto}
 * as its {@code additionalData} property, and provides extra attributes that enrich
 * the discussion resource event.
 * </p>
 */
@SuperBuilder
@Data
@NoArgsConstructor
public class DiscussionThreadMessagingAdditionalDataDto {

    /**
     * The parent discussion id.
     */
    private UUID discussionId;

    /**
     * The parent discussion title
     */
    private String discussionTitle;

    /**
     * The identifier of an external resource associated with the discussion.
     */
    private UUID discussionResourceId;

    /**
     * The type of the external resource associated with the discussion.
     */
    private String discussionResourceType;

    /**
     * Users to be notified (if applicable).
     */
    private Set<String> notifyUserIds;
}
