package com.finconsgroup.itserr.marketplace.discussion.bs.utils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;

/**
 * A wrapper class for extracting only the "status" field from entity payloads.
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class EntityStatusWrapper {
    /**
     * The status extracted from the entity payloads.
     * <p>
     * This field corresponds to the "status" field in the incoming JSON payload.
     * The field is case-sensitive and expects the JSON property to be named "status".
     * </p>
     */
    private String status;

    private EntityItemAdditionalDataWrapper additionalData;

}
