/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.discussion.bs.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.finconsgroup.itserr.marketplace.discussion.bs.dto.OutputUserProfileDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import java.time.ZonedDateTime;
import java.util.UUID;
import lombok.Generated;

@Schema(name="OutputUserProfile", description="DTO representing a userprofile in responses")
public class OutputUserProfileDto {
    @Schema(description="Unique identifier of the user profile", example="550e8400-e29b-41d4-a716-446655440000")
    private UUID id;
    @Schema(description="First name of the user", example="John")
    private String firstName;
    @Schema(description="Last name of the user", example="Doe")
    private String lastName;
    @Schema(description="Email address of the user", example="john.doe@example.com")
    private String email;
    @Schema(description="preferred Username of the user", example="john.doe.213213")
    private String preferredUsername;
    @Schema(description="Whether the user exists or not", example="true")
    private boolean userExists;
    @Schema(description="Folder Id of the User Profile", example="550e8400-e29b-41d4-a716-446655440000")
    private UUID userProfileFolderId;
    @Schema(description="Link of the image of user", example="https://imageLink")
    private String imageUrl;
    @Schema(description="ORCID identifier of the user", example="0000-0002-1825-0097")
    private String orcid;
    @Schema(description="Whether the user is open to collaboration", example="false")
    private boolean openToCollaboration;
    @Schema(description="Whether the user's email is publicly visible", example="true")
    private boolean showPublicEmail;
    @Schema(description="Personal website URL", example="https://johndoe.example.com")
    private String personalWebsite;
    @Schema(description="LinkedIn profile URL", example="https://linkedin.com/in/johndoe")
    private String linkedinProfile;
    @Schema(description="Social profile URL (e.g., GitHub)", example="https://github.com/johndoe")
    private String socialProfile;
    @Schema(description="Short biography of the user", example="Ricercatore Legge 210/10 a tempo indeterminato")
    private String shortBio;
    @Schema(description="Organization affiliation", example="Stanford University")
    private String organizationAffiliation;
    @Schema(description="The creation time of the table record", example="2025-04-06T10:15:30+01:00")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ssXXX")
    private ZonedDateTime creationTime;
    @Schema(description="The last update time of the table record", example="2025-04-06T10:15:30+01:00")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ssXXX")
    private ZonedDateTime updateTime;
    @Schema(description="User preferred language", example="EN")
    @NotBlank
    private String language;

    @Generated
    public static OutputUserProfileDtoBuilder builder() {
        return new OutputUserProfileDtoBuilder();
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public String getFirstName() {
        return this.firstName;
    }

    @Generated
    public String getLastName() {
        return this.lastName;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getPreferredUsername() {
        return this.preferredUsername;
    }

    @Generated
    public boolean isUserExists() {
        return this.userExists;
    }

    @Generated
    public UUID getUserProfileFolderId() {
        return this.userProfileFolderId;
    }

    @Generated
    public String getImageUrl() {
        return this.imageUrl;
    }

    @Generated
    public String getOrcid() {
        return this.orcid;
    }

    @Generated
    public boolean isOpenToCollaboration() {
        return this.openToCollaboration;
    }

    @Generated
    public boolean isShowPublicEmail() {
        return this.showPublicEmail;
    }

    @Generated
    public String getPersonalWebsite() {
        return this.personalWebsite;
    }

    @Generated
    public String getLinkedinProfile() {
        return this.linkedinProfile;
    }

    @Generated
    public String getSocialProfile() {
        return this.socialProfile;
    }

    @Generated
    public String getShortBio() {
        return this.shortBio;
    }

    @Generated
    public String getOrganizationAffiliation() {
        return this.organizationAffiliation;
    }

    @Generated
    public ZonedDateTime getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public ZonedDateTime getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public String getLanguage() {
        return this.language;
    }

    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Generated
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Generated
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setPreferredUsername(String preferredUsername) {
        this.preferredUsername = preferredUsername;
    }

    @Generated
    public void setUserExists(boolean userExists) {
        this.userExists = userExists;
    }

    @Generated
    public void setUserProfileFolderId(UUID userProfileFolderId) {
        this.userProfileFolderId = userProfileFolderId;
    }

    @Generated
    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    @Generated
    public void setOrcid(String orcid) {
        this.orcid = orcid;
    }

    @Generated
    public void setOpenToCollaboration(boolean openToCollaboration) {
        this.openToCollaboration = openToCollaboration;
    }

    @Generated
    public void setShowPublicEmail(boolean showPublicEmail) {
        this.showPublicEmail = showPublicEmail;
    }

    @Generated
    public void setPersonalWebsite(String personalWebsite) {
        this.personalWebsite = personalWebsite;
    }

    @Generated
    public void setLinkedinProfile(String linkedinProfile) {
        this.linkedinProfile = linkedinProfile;
    }

    @Generated
    public void setSocialProfile(String socialProfile) {
        this.socialProfile = socialProfile;
    }

    @Generated
    public void setShortBio(String shortBio) {
        this.shortBio = shortBio;
    }

    @Generated
    public void setOrganizationAffiliation(String organizationAffiliation) {
        this.organizationAffiliation = organizationAffiliation;
    }

    @Generated
    public void setCreationTime(ZonedDateTime creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setUpdateTime(ZonedDateTime updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setLanguage(String language) {
        this.language = language;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OutputUserProfileDto)) {
            return false;
        }
        OutputUserProfileDto other = (OutputUserProfileDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isUserExists() != other.isUserExists()) {
            return false;
        }
        if (this.isOpenToCollaboration() != other.isOpenToCollaboration()) {
            return false;
        }
        if (this.isShowPublicEmail() != other.isShowPublicEmail()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$firstName = this.getFirstName();
        String other$firstName = other.getFirstName();
        if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
            return false;
        }
        String this$lastName = this.getLastName();
        String other$lastName = other.getLastName();
        if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$preferredUsername = this.getPreferredUsername();
        String other$preferredUsername = other.getPreferredUsername();
        if (this$preferredUsername == null ? other$preferredUsername != null : !this$preferredUsername.equals(other$preferredUsername)) {
            return false;
        }
        UUID this$userProfileFolderId = this.getUserProfileFolderId();
        UUID other$userProfileFolderId = other.getUserProfileFolderId();
        if (this$userProfileFolderId == null ? other$userProfileFolderId != null : !((Object)this$userProfileFolderId).equals(other$userProfileFolderId)) {
            return false;
        }
        String this$imageUrl = this.getImageUrl();
        String other$imageUrl = other.getImageUrl();
        if (this$imageUrl == null ? other$imageUrl != null : !this$imageUrl.equals(other$imageUrl)) {
            return false;
        }
        String this$orcid = this.getOrcid();
        String other$orcid = other.getOrcid();
        if (this$orcid == null ? other$orcid != null : !this$orcid.equals(other$orcid)) {
            return false;
        }
        String this$personalWebsite = this.getPersonalWebsite();
        String other$personalWebsite = other.getPersonalWebsite();
        if (this$personalWebsite == null ? other$personalWebsite != null : !this$personalWebsite.equals(other$personalWebsite)) {
            return false;
        }
        String this$linkedinProfile = this.getLinkedinProfile();
        String other$linkedinProfile = other.getLinkedinProfile();
        if (this$linkedinProfile == null ? other$linkedinProfile != null : !this$linkedinProfile.equals(other$linkedinProfile)) {
            return false;
        }
        String this$socialProfile = this.getSocialProfile();
        String other$socialProfile = other.getSocialProfile();
        if (this$socialProfile == null ? other$socialProfile != null : !this$socialProfile.equals(other$socialProfile)) {
            return false;
        }
        String this$shortBio = this.getShortBio();
        String other$shortBio = other.getShortBio();
        if (this$shortBio == null ? other$shortBio != null : !this$shortBio.equals(other$shortBio)) {
            return false;
        }
        String this$organizationAffiliation = this.getOrganizationAffiliation();
        String other$organizationAffiliation = other.getOrganizationAffiliation();
        if (this$organizationAffiliation == null ? other$organizationAffiliation != null : !this$organizationAffiliation.equals(other$organizationAffiliation)) {
            return false;
        }
        ZonedDateTime this$creationTime = this.getCreationTime();
        ZonedDateTime other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        ZonedDateTime this$updateTime = this.getUpdateTime();
        ZonedDateTime other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        return !(this$language == null ? other$language != null : !this$language.equals(other$language));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OutputUserProfileDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUserExists() ? 79 : 97);
        result = result * 59 + (this.isOpenToCollaboration() ? 79 : 97);
        result = result * 59 + (this.isShowPublicEmail() ? 79 : 97);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $firstName = this.getFirstName();
        result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
        String $lastName = this.getLastName();
        result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $preferredUsername = this.getPreferredUsername();
        result = result * 59 + ($preferredUsername == null ? 43 : $preferredUsername.hashCode());
        UUID $userProfileFolderId = this.getUserProfileFolderId();
        result = result * 59 + ($userProfileFolderId == null ? 43 : ((Object)$userProfileFolderId).hashCode());
        String $imageUrl = this.getImageUrl();
        result = result * 59 + ($imageUrl == null ? 43 : $imageUrl.hashCode());
        String $orcid = this.getOrcid();
        result = result * 59 + ($orcid == null ? 43 : $orcid.hashCode());
        String $personalWebsite = this.getPersonalWebsite();
        result = result * 59 + ($personalWebsite == null ? 43 : $personalWebsite.hashCode());
        String $linkedinProfile = this.getLinkedinProfile();
        result = result * 59 + ($linkedinProfile == null ? 43 : $linkedinProfile.hashCode());
        String $socialProfile = this.getSocialProfile();
        result = result * 59 + ($socialProfile == null ? 43 : $socialProfile.hashCode());
        String $shortBio = this.getShortBio();
        result = result * 59 + ($shortBio == null ? 43 : $shortBio.hashCode());
        String $organizationAffiliation = this.getOrganizationAffiliation();
        result = result * 59 + ($organizationAffiliation == null ? 43 : $organizationAffiliation.hashCode());
        ZonedDateTime $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        ZonedDateTime $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OutputUserProfileDto(id=" + String.valueOf(this.getId()) + ", firstName=" + this.getFirstName() + ", lastName=" + this.getLastName() + ", email=" + this.getEmail() + ", preferredUsername=" + this.getPreferredUsername() + ", userExists=" + this.isUserExists() + ", userProfileFolderId=" + String.valueOf(this.getUserProfileFolderId()) + ", imageUrl=" + this.getImageUrl() + ", orcid=" + this.getOrcid() + ", openToCollaboration=" + this.isOpenToCollaboration() + ", showPublicEmail=" + this.isShowPublicEmail() + ", personalWebsite=" + this.getPersonalWebsite() + ", linkedinProfile=" + this.getLinkedinProfile() + ", socialProfile=" + this.getSocialProfile() + ", shortBio=" + this.getShortBio() + ", organizationAffiliation=" + this.getOrganizationAffiliation() + ", creationTime=" + String.valueOf(this.getCreationTime()) + ", updateTime=" + String.valueOf(this.getUpdateTime()) + ", language=" + this.getLanguage() + ")";
    }

    @Generated
    public OutputUserProfileDto() {
    }

    @Generated
    public OutputUserProfileDto(UUID id, String firstName, String lastName, String email, String preferredUsername, boolean userExists, UUID userProfileFolderId, String imageUrl, String orcid, boolean openToCollaboration, boolean showPublicEmail, String personalWebsite, String linkedinProfile, String socialProfile, String shortBio, String organizationAffiliation, ZonedDateTime creationTime, ZonedDateTime updateTime, String language) {
        this.id = id;
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.preferredUsername = preferredUsername;
        this.userExists = userExists;
        this.userProfileFolderId = userProfileFolderId;
        this.imageUrl = imageUrl;
        this.orcid = orcid;
        this.openToCollaboration = openToCollaboration;
        this.showPublicEmail = showPublicEmail;
        this.personalWebsite = personalWebsite;
        this.linkedinProfile = linkedinProfile;
        this.socialProfile = socialProfile;
        this.shortBio = shortBio;
        this.organizationAffiliation = organizationAffiliation;
        this.creationTime = creationTime;
        this.updateTime = updateTime;
        this.language = language;
    }
}

