/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.discussion.bs.messaging.producer.impl;

import com.finconsgroup.itserr.marketplace.discussion.bs.config.properties.DiscussionBsConfigurationProperties;
import com.finconsgroup.itserr.marketplace.discussion.bs.messaging.producer.DiscussionEventProducer;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import com.finconsgroup.itserr.messaging.exception.WP2MessagingException;
import com.finconsgroup.itserr.messaging.producer.MessageProducer;
import com.finconsgroup.itserr.messaging.producer.ProducerRegistry;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"messaging.enabled"}, havingValue="true")
public class DefaultDiscussionEventProducer
implements DiscussionEventProducer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultDiscussionEventProducer.class);
    private final MessageProducer messageProducer;
    private final DiscussionBsConfigurationProperties.MessagingProperties messagingProperties;

    public DefaultDiscussionEventProducer(DiscussionBsConfigurationProperties discussionBsConfigurationProperties, ProducerRegistry producerRegistry) {
        this.messagingProperties = discussionBsConfigurationProperties.getMessaging();
        this.messageProducer = producerRegistry.getMessageProducer(this.messagingProperties.getEventProducerName());
    }

    public void publishCreateEvent(@NonNull MessagingEventDto<?> eventDto) {
        this.publish(eventDto, this.messagingProperties.getResourceThreadCreatedEventType());
    }

    private void publish(@NonNull MessagingEventDto<?> eventDto, @NonNull String eventType) {
        try {
            Map<String, MessagingEventDto<?>> messageMap = Map.of(eventDto.getId(), eventDto);
            Map<String, String> filterProperties = Map.of("service", "discussion");
            log.debug("Sending message, messageMap: %s, eventType: %s, source: %s, filterProperties: %s".formatted(messageMap, eventType, this.messagingProperties.getSource(), filterProperties));
            this.messageProducer.publishEvent(messageMap, eventType, this.messagingProperties.getSource(), filterProperties);
            log.info("Successfully published event message for discussion with the following info: {}", eventDto);
        }
        catch (Exception e) {
            String errorMessage = "Error occurred while sending event message: %s".formatted(e.getMessage());
            throw new WP2MessagingException(errorMessage, (Throwable)e);
        }
    }
}

