package com.finconsgroup.itserr.marketplace.event.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import static com.finconsgroup.itserr.marketplace.event.dm.util.DomainConstants.SHORT_TEXT_LENGTH;

/**
 * Input DTO for creating a location.
 */
@Schema(name = "InputLocationDto", description = "DTO for creating a location")
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public class InputLocationDto {

    @Schema(description = "City", example = "Palo Alto")
    @Size(max = SHORT_TEXT_LENGTH)
    private String city;

    @Schema(description = "Region or State", example = "CA")
    @Size(max = SHORT_TEXT_LENGTH)
    private String region;

    @Schema(description = "Country", example = "USA")
    @Size(max = SHORT_TEXT_LENGTH)
    private String country;

    @Schema(description = "Zip Code", example = "90100")
    @Size(max = SHORT_TEXT_LENGTH)
    private String zipCode;
}

