package com.finconsgroup.itserr.marketplace.event.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * Output DTO for program conductor.
 */
@Schema(name = "OutputProgramConductorDto", description = "DTO for program conductor")
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public class OutputProgramConductorDto {

    @Schema(description = "The first name", example = "John")
    private String firstName;

    @Schema(description = "The last name", example = "Doe")
    private String lastName;

    @Schema(description = "The email", example = "john.doe@example.com")
    private String email;

    @Schema(description = "ORCID identifier of the user", example = "0000-0002-1825-0097")
    private String orcid;

}
