package com.finconsgroup.itserr.marketplace.event.dm.mapper;

import com.finconsgroup.itserr.marketplace.event.dm.dto.InputProgramConductorDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.OutputProgramConductorDto;
import com.finconsgroup.itserr.marketplace.event.dm.entity.ProgramConductorEntity;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.NullValueMappingStrategy;

@Mapper(config = MapperConfiguration.class)
public interface ProgramConductorMapper {

    @Mapping(target = "id", ignore = true)
    @Mapping(target = "creationTime", ignore = true)
    @Mapping(target = "updateTime", ignore = true)
    @Mapping(target = "version", ignore = true)
    @Mapping(target = "conductorOrder", ignore = true)
    @Mapping(target = "program", ignore = true)
    @Mapping(target = "programId", ignore = true)
    ProgramConductorEntity toEntity(InputProgramConductorDto inputProgramConductorDto);

    OutputProgramConductorDto toDto(ProgramConductorEntity entity);

    @Mapping(target = "id", ignore = true)
    @Mapping(target = "creationTime", ignore = true)
    @Mapping(target = "updateTime", ignore = true)
    @Mapping(target = "version", ignore = true)
    @Mapping(target = "conductorOrder", ignore = true)
    @Mapping(target = "program", ignore = true)
    @Mapping(target = "programId", ignore = true)
    @IterableMapping(nullValueMappingStrategy = NullValueMappingStrategy.RETURN_DEFAULT)
    void updateEntity(InputProgramConductorDto dto, @MappingTarget ProgramConductorEntity entity);
}
