package com.finconsgroup.itserr.marketplace.event.dm.repository;

import com.finconsgroup.itserr.marketplace.event.dm.entity.EventConductorEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.UUID;

/**
 * {@link EventConductorRepository} repository.
 */
@Repository
public interface EventConductorRepository extends JpaRepository<EventConductorEntity, UUID> {

    /**
     * Retrieves the event conductors for provided event ids
     *
     * @param eventIds the unique identifier of the events to be retrieved
     * @return an {@link List} containing the matching {@link EventConductorEntity}s if found, or an empty {@link List} if no match exists
     */
    List<EventConductorEntity> findAllByEventIdIn(List<UUID> eventIds);

}
