package com.finconsgroup.itserr.marketplace.event.dm.repository;

import com.finconsgroup.itserr.marketplace.event.dm.entity.SubscribedParticipantEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Optional;
import java.util.UUID;

/**
 * {@link SubscribedParticipantRepository} repository.
 */
@Repository
public interface SubscribedParticipantRepository extends JpaRepository<SubscribedParticipantEntity, UUID> {

    /**
     * Retrieves the subscribed participants for provided event ids
     *
     * @param eventIds the unique identifier of the events to be retrieved
     * @return an {@link List} containing the matching {@link SubscribedParticipantEntity}s if found, or an empty {@link List} if no match exists
     */
    List<SubscribedParticipantEntity> findAllByEventIdIn(List<UUID> eventIds);

    /**
     * checks if a user is already subscribed to an event
     *
     * @param userId  the unique identifier of a user
     * @param eventId the unique identifier of an event
     */
    boolean existsByUserIdAndEventId(UUID userId, UUID eventId);

    /**
     * Retrieves the subscribed participant entry by userId and eventId
     *
     * @param userId  the unique identifier of a user
     * @param eventId the unique identifier of an event
     */
    Optional<SubscribedParticipantEntity> findByUserIdAndEventId(UUID userId, UUID eventId);
}
