package com.finconsgroup.itserr.marketplace.event.dm.service;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2DuplicateResourceException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.event.dm.dto.InputProgramSubscribedParticipantDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.OutputEventDto;
import com.finconsgroup.itserr.marketplace.event.dm.exception.WP2ProgramCapacityExceededException;
import org.springframework.lang.NonNull;

import java.util.UUID;

/**
 * Service for handling business logic related to Program. This interface provides methods to register and unregister to a program.
 */
public interface ProgramService {

    /**
     * register a user to a program
     *
     * @param userId    the id of the user
     * @param eventId   the id of the event
     * @param programId the id of the program
     * @throws WP2ResourceNotFoundException        if no program is found with the given id
     * @throws WP2DuplicateResourceException       if user is already subscribed to the program
     * @throws WP2ProgramCapacityExceededException if the program reached its maximum capacity
     */
    @NonNull
    OutputEventDto register(@NonNull UUID userId,
                            @NonNull UUID eventId,
                            @NonNull UUID programId,
                            @NonNull InputProgramSubscribedParticipantDto inputProgramSubscribedParticipantDto);

    /**
     * unregister a user to a program
     *
     * @param userId    the id of the user
     * @param eventId   the id of the event
     * @param programId the id of the program
     * @throws WP2ResourceNotFoundException if no program is found with the given id
     */
    @NonNull
    OutputEventDto unregister(@NonNull UUID userId,
                              @NonNull UUID eventId,
                              @NonNull UUID programId);

}
