package com.finconsgroup.itserr.marketplace.institutional_page.bs.client.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.UUID;

/**
 * Output DTO representing a catalog item type.
 */
@Schema(
        name = "TypeCatalogBsDto",
        description = "Output DTO representing a catalog item type"
)
@Data
@Builder
@AllArgsConstructor
public class TypeCatalogBsDto {

    @Schema(description = "Unique identifier of the type", example = "3fa85f64-5717-4562-b3fc-2c963f66afa6")
    private UUID id;

    @Schema(description = "Name of the type", example = "3D Images")
    private String name;

    @Schema(description = "Description of the type", example = "3D Images item type")
    private String description;

}
