package com.finconsgroup.itserr.marketplace.institutional_page.bs.config.properties;

import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import java.net.URI;

/**
 * Configuration properties for the workspace-bs service.
 */
@Validated
@Data
@NoArgsConstructor
@AllArgsConstructor
@ConfigurationProperties(prefix = "workspace-bs")
public class WorkspaceBsConfigurationProperties {
    /**
     * Base URL for workspace-bs API calls.
     */
    @NotNull
    private URI baseUrl;
}
