package com.finconsgroup.itserr.marketplace.institutional_page.bs.controller;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.api.PublishedInstitutionalPageApi;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputSearchPublishedInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.service.PublishedInstitutionalPageService;
import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

import java.util.Set;
import java.util.UUID;

@RestController
@RequiredArgsConstructor
public class PublishedInstitutionalPageController implements PublishedInstitutionalPageApi {
    private final PublishedInstitutionalPageService publishedInstitutionalPageService;

    @Override
    public ResponseEntity<OutputPageDto<OutputInstitutionalPageDto>> getAllPublishedInstitutionalPages(Set<String> associationsToLoad, int pageNumber, int pageSize, String sort, SortDirection direction, boolean withPublications) {
        OutputPageDto<OutputInstitutionalPageDto> institutionalPages = publishedInstitutionalPageService.getAllPublishedInstitutionalPages(associationsToLoad, pageNumber, pageSize, sort, direction, withPublications);
        return new ResponseEntity<>(institutionalPages, HttpStatus.OK);
    }

    @Override
    public ResponseEntity<OutputInstitutionalPageDto> getPublishedInstitutionalPageById(UUID institutionalPageId, boolean withPublications) {
        OutputInstitutionalPageDto institutionalPage = publishedInstitutionalPageService.getPublishedInstitutionalPageById(institutionalPageId, withPublications);
        return new ResponseEntity<>(institutionalPage, HttpStatus.OK);
    }

    @Override
    public ResponseEntity<OutputPageDto<OutputInstitutionalPageDto>> search(InputSearchPublishedInstitutionalPageDto inputSearchInstitutionalPageDto, Set<String> associationsToLoad, int pageNumber, int pageSize, String sort, SortDirection direction, boolean withPublications) {
        OutputPageDto<OutputInstitutionalPageDto> institutionalPages = publishedInstitutionalPageService.search(inputSearchInstitutionalPageDto, associationsToLoad, pageNumber, pageSize, sort, direction, withPublications);
        return new ResponseEntity<>(institutionalPages, HttpStatus.OK);
    }
}
